<?php require_once '../../includes/header.php'; ?>

<div class="max-w-7xl mx-auto pb-24 md:pb-12 px-4 md:px-6 pt-6">

    <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-4 mb-8 fade-in-up">
        <div>
            <nav class="flex text-[10px] font-bold text-gray-400 mb-2 uppercase tracking-wider">
                <a href="list.php" class="hover:text-indigo-600 transition-colors">Leads</a> 
                <span class="mx-2">/</span> 
                <span>Details</span>
            </nav>
            <div class="flex items-center gap-3">
                <h1 class="text-2xl md:text-3xl font-extrabold text-navy-700 tracking-tight" id="header-name">
                    <div class="h-8 w-48 bg-gray-100 rounded-lg animate-pulse"></div>
                </h1>
                <span id="header-status" class="hidden px-3 py-1 rounded-full text-[10px] font-extrabold uppercase tracking-wide border shadow-sm">
                    </span>
            </div>
            <p class="text-xs text-gray-500 font-medium mt-1 flex items-center gap-2">
                <i class="ph-fill ph-identification-card"></i> <span id="header-no">#...</span>
                <span class="w-1 h-1 rounded-full bg-gray-300"></span>
                <span id="header-owner" class="text-indigo-600 font-bold">...</span>
            </p>
        </div>
        
        <div class="flex gap-3 w-full md:w-auto">
             <button onclick="history.back()" class="flex-1 md:flex-none bg-white border border-gray-200 text-gray-600 px-5 py-2.5 rounded-xl text-xs font-bold hover:bg-gray-50 transition-all shadow-sm">
                <i class="ph-bold ph-arrow-left"></i> Back
            </button>
             <button onclick="goToEdit()" class="flex-1 md:flex-none bg-navy-700 text-white px-6 py-2.5 rounded-xl text-xs font-bold hover:shadow-lg hover:shadow-navy-700/20 transition-all shadow-md flex items-center justify-center gap-2">
                <i class="ph-bold ph-pencil-simple"></i> Edit Lead
            </button>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 lg:gap-8">

        <div class="lg:col-span-1 space-y-6">
            
            <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 relative overflow-hidden group hover:shadow-md transition-all duration-300">
                <div class="absolute top-0 right-0 p-5 opacity-[0.03] group-hover:opacity-[0.06] transition-opacity">
                    <i class="ph-fill ph-user-circle text-9xl text-indigo-900"></i>
                </div>
                
                <h3 class="text-xs font-extrabold text-gray-400 uppercase tracking-wide mb-5">Contact Info</h3>
                
                <div class="space-y-5 relative z-10">
                    <div class="flex items-center gap-4 cursor-pointer" onclick="triggerCall('val-mobile')">
                        <div class="w-10 h-10 rounded-xl bg-green-50 text-green-600 flex items-center justify-center text-lg shadow-sm border border-green-100 group-active:scale-95 transition-transform">
                            <i class="ph-fill ph-phone"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-[10px] font-bold text-gray-400 uppercase">Mobile</p>
                            <p class="text-sm font-bold text-navy-700 break-all" id="val-mobile">--</p>
                        </div>
                    </div>
                    <div class="flex items-center gap-4">
                        <div class="w-10 h-10 rounded-xl bg-gray-50 text-gray-500 flex items-center justify-center text-lg shadow-sm border border-gray-100">
                            <i class="ph-fill ph-phone-call"></i>
                        </div>
                        <div class="flex-1">
                            <p class="text-[10px] font-bold text-gray-400 uppercase">Primary Phone</p>
                            <p class="text-sm font-bold text-navy-700 break-all" id="val-phone">--</p>
                        </div>
                    </div>
                    <div class="flex items-center gap-4">
                        <div class="w-10 h-10 rounded-xl bg-blue-50 text-blue-600 flex items-center justify-center text-lg shadow-sm border border-blue-100">
                            <i class="ph-fill ph-envelope-simple"></i>
                        </div>
                        <div class="flex-1 overflow-hidden">
                            <p class="text-[10px] font-bold text-gray-400 uppercase">Email</p>
                            <p class="text-sm font-bold text-navy-700 truncate" id="val-email">--</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 hover:shadow-md transition-all duration-300">
                <h3 class="text-xs font-extrabold text-gray-400 uppercase tracking-wide mb-4">Classification</h3>
                
                <div class="space-y-3">
                    <div class="flex justify-between items-center py-2 border-b border-gray-50">
                        <span class="text-xs font-medium text-gray-500">Project</span>
                        <span class="text-xs font-bold text-indigo-600 bg-indigo-50 px-2 py-1 rounded-lg" id="val-project">--</span>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-gray-50">
                        <span class="text-xs font-medium text-gray-500">Unit Type</span>
                        <span class="text-xs font-bold text-navy-700" id="val-unit-type">--</span>
                    </div>
                     <div class="flex justify-between items-center py-2 border-b border-gray-50">
                        <span class="text-xs font-medium text-gray-500">Specs</span>
                        <span class="text-xs font-bold text-navy-700" id="val-unit-specs">--</span>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-gray-50">
                        <span class="text-xs font-medium text-gray-500">Channel</span>
                        <span class="text-xs font-bold text-navy-700" id="val-channel">--</span>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-gray-50">
                        <span class="text-xs font-medium text-gray-500">Source</span>
                        <span class="text-xs font-bold text-navy-700" id="val-source">--</span>
                    </div>
                     <div class="flex justify-between items-center py-2 border-b border-gray-50">
                        <span class="text-xs font-medium text-gray-500">Assigned To</span>
                        <span class="text-xs font-bold text-navy-700" id="val-owner">--</span>
                    </div>
                    <div class="flex justify-between items-center py-2 border-b border-gray-50">
                        <span class="text-xs font-medium text-gray-500">System Status</span>
                        <span class="text-xs font-bold text-gray-700" id="val-sys-status">--</span>
                    </div>
                </div>
                
                <div class="mt-5 pt-4 border-t border-gray-100 flex justify-between">
                    <div class="text-center">
                        <p class="text-[10px] text-gray-400 font-bold uppercase">Created</p>
                        <p class="text-[10px] font-bold text-navy-700 mt-0.5" id="val-created">--</p>
                    </div>
                    <div class="text-center">
                        <p class="text-[10px] text-gray-400 font-bold uppercase">Modified</p>
                        <p class="text-[10px] font-bold text-navy-700 mt-0.5" id="val-modified">--</p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100">
                <h3 class="text-xs font-extrabold text-gray-400 uppercase tracking-wide mb-3">Latest Interaction</h3>
                <div id="latest-log-area" class="bg-gray-50 rounded-xl p-3 border border-gray-100">
                    <p class="text-xs text-gray-400 italic">Loading...</p>
                </div>
            </div>
        </div>

        <div class="lg:col-span-2">
            
            <div class="hidden md:block bg-white rounded-2xl shadow-sm border border-gray-100 p-1 mb-8">
                <div class="flex border-b border-gray-100">
                    <button onclick="setMode('comment')" id="tab-comment" class="flex-1 py-3 text-xs font-bold text-indigo-600 border-b-2 border-indigo-600 bg-indigo-50/50 transition-all rounded-t-xl"><i class="ph-bold ph-chat-text"></i> Note</button>
                    <button onclick="setMode('call')" id="tab-call" class="flex-1 py-3 text-xs font-bold text-gray-500 hover:bg-gray-50 transition-all"><i class="ph-bold ph-phone"></i> Log Call</button>
                    <button onclick="setMode('meeting')" id="tab-meeting" class="flex-1 py-3 text-xs font-bold text-gray-500 hover:bg-gray-50 transition-all"><i class="ph-bold ph-users"></i> Meeting</button>
                </div>
                <div class="p-4">
                    <textarea id="act-desc" rows="3" class="w-full bg-gray-50 border-0 rounded-xl p-4 text-sm outline-none resize-none focus:ring-2 focus:ring-indigo-100 transition-all" placeholder="Write a note..."></textarea>
                    
                    <div id="act-extras" class="hidden grid-cols-2 gap-3 mt-3 animate-fade-in">
                        <input type="date" id="act-date" class="bg-gray-50 rounded-xl px-3 py-2 text-xs font-bold border-0 outline-none text-gray-600">
                        <select id="act-status" class="bg-gray-50 rounded-xl px-3 py-2 text-xs font-bold border-0 outline-none text-gray-600">
                            <option value="Held">Held (Completed)</option>
                            <option value="Planned">Planned (Future)</option>
                        </select>
                    </div>

                    <div class="flex justify-between items-center mt-3">
                        <span class="text-[10px] font-bold text-gray-400 uppercase tracking-wide" id="act-label">New Note</span>
                        <button onclick="postActivity()" id="btn-post" class="bg-navy-700 text-white px-6 py-2 rounded-xl text-xs font-bold shadow-lg shadow-navy-700/20 hover:shadow-navy-700/40 transition-all transform hover:-translate-y-0.5">
                            Post Activity
                        </button>
                    </div>
                </div>
            </div>

            <div class="flex items-center justify-between mb-5 px-1">
                <h3 class="text-sm font-extrabold text-navy-700 flex items-center gap-2">
                    <i class="ph-bold ph-clock-counter-clockwise text-indigo-500"></i> History
                </h3>
                <button onclick="loadTimeline()" class="w-8 h-8 rounded-full bg-white border border-gray-200 text-gray-400 hover:text-indigo-600 flex items-center justify-center transition-all shadow-sm">
                    <i class="ph-bold ph-arrows-clockwise"></i>
                </button>
            </div>

            <div id="timeline-container" class="space-y-4 relative pb-20">
                <div class="absolute left-6 top-4 bottom-4 w-0.5 bg-gray-100 z-0 hidden md:block"></div>
            </div>
            
            <div id="timeline-loader" class="hidden py-10 text-center">
                 <div class="inline-block w-8 h-8 border-4 border-indigo-100 border-t-indigo-600 rounded-full animate-spin"></div>
            </div>

        </div>
    </div>
</div>

<button onclick="openMobileDrawer()" class="md:hidden fixed bottom-6 right-6 w-14 h-14 bg-indigo-600 text-white rounded-full shadow-2xl shadow-indigo-600/40 flex items-center justify-center text-2xl z-50 hover:scale-105 active:scale-95 transition-all">
    <i class="ph-bold ph-plus"></i>
</button>

<div id="mobile-drawer" class="fixed inset-0 z-[60] hidden">
    <div class="absolute inset-0 bg-black/50 backdrop-blur-sm transition-opacity" onclick="closeMobileDrawer()"></div>
    <div class="absolute bottom-0 left-0 right-0 bg-white rounded-t-[32px] p-6 shadow-2xl transform transition-transform translate-y-full duration-300 ease-out" id="drawer-content">
        <div class="w-12 h-1.5 bg-gray-200 rounded-full mx-auto mb-6"></div>
        <h3 class="text-lg font-extrabold text-navy-700 mb-4">Log Activity</h3>
        <div class="grid grid-cols-3 gap-3 mb-4">
             <button onclick="setMobileMode('comment')" id="mob-btn-comment" class="flex flex-col items-center gap-2 p-3 rounded-2xl bg-indigo-50 text-indigo-600 border border-indigo-100 ring-2 ring-indigo-200"><i class="ph-fill ph-chat-text text-xl"></i> <span class="text-[10px] font-bold">Note</span></button>
             <button onclick="setMobileMode('call')" id="mob-btn-call" class="flex flex-col items-center gap-2 p-3 rounded-2xl bg-gray-50 text-gray-500 border border-gray-100"><i class="ph-fill ph-phone text-xl"></i> <span class="text-[10px] font-bold">Call</span></button>
             <button onclick="setMobileMode('meeting')" id="mob-btn-meeting" class="flex flex-col items-center gap-2 p-3 rounded-2xl bg-gray-50 text-gray-500 border border-gray-100"><i class="ph-fill ph-users text-xl"></i> <span class="text-[10px] font-bold">Meet</span></button>
        </div>
        <textarea id="mob-desc" rows="3" class="w-full bg-gray-50 border-0 rounded-xl p-4 text-sm outline-none resize-none mb-4 focus:ring-2 focus:ring-indigo-100 transition-all" placeholder="Write a note..."></textarea>
        <button onclick="postMobileActivity()" class="w-full bg-navy-700 text-white py-3.5 rounded-xl text-sm font-bold shadow-lg">Submit</button>
    </div>
</div>

<script>
    // === SPLIT STRATEGY: Read from Standard, Write to Gateway ===
    const READ_API_URL = GLOBAL_API_URL; 
    const WRITE_API_URL = 'direct_gateway.php'; 

    const SESSION = localStorage.getItem('vt_session');
    const RECORD_ID = new URLSearchParams(window.location.search).get('id');
    let userMap = JSON.parse(localStorage.getItem('vt_umap_v7') || '{}');
    let currentMode = 'comment';
    let mobMode = 'comment';

    document.addEventListener('DOMContentLoaded', async () => {
        if(!SESSION || !RECORD_ID) { window.location.href='list.php'; return; }
        
        if(Object.keys(userMap).length < 2) await fetchUsersMap(); 
        
        loadDetails();
        loadTimeline();
        document.getElementById('act-date').valueAsDate = new Date();
    });

    // 1. FETCH DETAILS (Uses READ_API_URL)
    async function loadDetails() {
        try {
            const res = await fetch(`${READ_API_URL}?operation=retrieve&sessionName=${SESSION}&id=${RECORD_ID}`);
            const data = await res.json();
            if(data.success) {
                const l = data.result;
                setText('header-name', `${l.firstname} ${l.lastname}`);
                setText('header-no', `#${l.lead_no}`);
                
                const status = l.leadstatus || 'New';
                const sBadge = document.getElementById('header-status');
                sBadge.innerText = status;
                sBadge.className = `hidden md:inline-block px-3 py-1 rounded-full text-[10px] font-extrabold uppercase tracking-wide border shadow-sm ${getStatusClasses(status)}`;
                sBadge.classList.remove('hidden');

                setText('val-mobile', l.mobile || '--');
                setText('val-phone', l.phone || '--');
                setText('val-email', l.email || '--');
                setText('val-source', l.leadsource || '--');
                setText('val-created', (l.createdtime||'').split(' ')[0]);
                setText('val-modified', (l.modifiedtime||'').split(' ')[0]);

                setText('val-project', l.cf_975 || '--'); 
                setText('val-unit-type', l.cf_979 || '--');
                setText('val-unit-specs', l.cf_981 || '--');
                setText('val-channel', l.cf_971 || '--');
                setText('val-sys-status', l.cf_2992 || '--');

                let owner = l.assigned_user_id;
                if(owner && owner.includes('x')) {
                    owner = userMap[owner] || (await resolveMissingUser(owner)) || 'User';
                }
                setText('header-owner', owner);
                setText('val-owner', owner);
            }
        } catch(e) { console.error(e); }
    }

    // 2. FETCH USERS (Uses READ_API_URL)
    async function fetchUsersMap() {
        try {
            const [u, g] = await Promise.all([
                fetch(`${READ_API_URL}?operation=query&sessionName=${SESSION}&query=${encodeURIComponent("SELECT id,first_name,last_name,user_name FROM Users LIMIT 1000")}`),
                fetch(`${READ_API_URL}?operation=query&sessionName=${SESSION}&query=${encodeURIComponent("SELECT id,groupname FROM Groups LIMIT 500")}`)
            ]);
            const ud = await u.json();
            const gd = await g.json();
            
            if(ud.success) ud.result.forEach(x => userMap[x.id] = ((x.first_name||x.last_name)?`${x.first_name} ${x.last_name}`:x.user_name).trim());
            if(gd.success) gd.result.forEach(x => userMap[x.id] = x.groupname);
            localStorage.setItem('vt_umap_v7', JSON.stringify(userMap));
        } catch(e) {}
    }
    
    async function resolveMissingUser(id) {
        try {
            const r = await fetch(`${READ_API_URL}?operation=retrieve&sessionName=${SESSION}&id=${id}`);
            const d = await r.json();
            if(d.success) {
                const res = d.result;
                const name = res.groupname || ((res.first_name||res.last_name)?`${res.first_name} ${res.last_name}`:res.user_name).trim();
                userMap[id] = name;
                return name;
            }
        } catch(e){}
        return id;
    }

    // 3. TIMELINE (Uses READ_API_URL)
    async function loadTimeline() {
        const c = document.getElementById('timeline-container');
        document.getElementById('timeline-loader').classList.remove('hidden');
        c.innerHTML = '';

        try {
            const [r1, r2] = await Promise.all([
                fetch(`${READ_API_URL}?operation=query&sessionName=${SESSION}&query=${encodeURIComponent(`SELECT commentcontent, createdtime, creator FROM ModComments WHERE related_to='${RECORD_ID}' ORDER BY createdtime DESC LIMIT 20`)}`),
                fetch(`${READ_API_URL}?operation=query&sessionName=${SESSION}&query=${encodeURIComponent(`SELECT subject, eventstatus, activitytype, date_start, time_start, description, assigned_user_id FROM Events WHERE parent_id='${RECORD_ID}' ORDER BY date_start DESC LIMIT 20`)}`)
            ]);
            
            const d1 = await r1.json();
            const d2 = await r2.json();
            let feed = [];

            if(d1.success) feed = feed.concat(d1.result.map(x=>({type:'note', ...x, date:x.createdtime})));
            if(d2.success) feed = feed.concat(d2.result.map(x=>({type:'event', ...x, date:x.date_start+' '+x.time_start})));
            
            feed.sort((a,b) => new Date(b.date) - new Date(a.date));
            document.getElementById('timeline-loader').classList.add('hidden');

            const latestBox = document.getElementById('latest-log-area');
            if(feed.length > 0) {
                const last = feed[0];
                const lType = last.type === 'note' ? 'Comment' : last.activitytype;
                const lTxt = last.type === 'note' ? last.commentcontent : last.subject;
                latestBox.innerHTML = `<div class="flex items-center gap-2 mb-1"><span class="px-2 py-0.5 bg-gray-200 text-gray-600 rounded text-[10px] font-bold uppercase">${lType}</span><span class="text-[10px] text-gray-400">${new Date(last.date).toLocaleDateString()}</span></div><p class="text-xs font-bold text-navy-700 line-clamp-2">"${lTxt}"</p>`;
            } else {
                latestBox.innerHTML = `<p class="text-xs text-gray-400 italic">No interaction recorded.</p>`;
            }

            if(feed.length===0) {
                c.innerHTML = `<div class="text-center text-gray-400 py-10 bg-gray-50 rounded-2xl border border-dashed border-gray-200"><i class="ph-duotone ph-chat-teardrop-dots text-4xl mb-2"></i><p class="text-xs font-bold">No history found.</p></div>`;
                return;
            }

            feed.forEach(item => {
                const isNote = item.type === 'note';
                let owner = item.creator || item.assigned_user_id;
                if(owner && owner.includes('x')) owner = userMap[owner] || 'User';
                
                const dateObj = new Date(item.date);
                const dateStr = dateObj.toLocaleDateString(undefined, {month:'short', day:'numeric'});
                const timeStr = dateObj.toLocaleTimeString(undefined, {hour:'2-digit', minute:'2-digit'});
                
                let icon = 'ph-chat-text'; let color = 'indigo';
                if(!isNote) {
                    if(item.activitytype==='Call') { icon='ph-phone'; color='green'; }
                    else { icon='ph-users'; color='orange'; }
                }

                c.insertAdjacentHTML('beforeend', `
                    <div class="relative z-10 flex gap-4 group animate-fade-in-up">
                        <div class="hidden md:flex w-12 h-12 rounded-full border-4 border-gray-50 bg-${color}-50 text-${color}-600 items-center justify-center text-xl shadow-sm flex-shrink-0 z-10"><i class="ph-fill ${icon}"></i></div>
                        <div class="flex-1 bg-white rounded-2xl p-5 border border-gray-100 shadow-sm group-hover:shadow-md transition-all">
                            <div class="flex justify-between items-start mb-2">
                                <div class="flex items-center gap-2">
                                    <div class="md:hidden w-8 h-8 rounded-lg bg-${color}-50 text-${color}-600 flex items-center justify-center text-sm"><i class="ph-fill ${icon}"></i></div>
                                    <div><h4 class="text-sm font-bold text-navy-700">${isNote ? 'Note' : item.subject}</h4><p class="text-[10px] text-gray-400 font-bold uppercase tracking-wide">${owner} • ${dateStr} ${timeStr}</p></div>
                                </div>
                                ${!isNote ? `<span class="px-2 py-0.5 rounded text-[10px] font-bold uppercase bg-gray-100 text-gray-500">${item.eventstatus}</span>` : ''}
                            </div>
                            <p class="text-sm text-gray-600 leading-relaxed whitespace-pre-wrap ml-0 md:ml-0">${isNote ? item.commentcontent : (item.description||'No details')}</p>
                        </div>
                    </div>
                `);
            });
        } catch(e) { console.error(e); }
    }

    // 4. POST ACTIONS (Uses WRITE_API_URL - The Gateway)
    async function postData(desc, mode, date, status) {
        if(!desc) return alert("Please type something.");
        const c = document.getElementById('timeline-container');
        c.insertAdjacentHTML('afterbegin', `<div class="bg-indigo-50 border border-indigo-100 p-4 rounded-xl text-center text-indigo-600 text-xs font-bold animate-pulse mb-4">Posting...</div>`);
        try {
            let payload = {};
            const uid = localStorage.getItem('vt_userid');
            if(mode==='comment') {
                payload = { operation:'create', sessionName:SESSION, elementType:'ModComments', element: JSON.stringify({ commentcontent:desc, related_to:RECORD_ID, assigned_user_id:uid }) };
            } else {
                const now = new Date();
                payload = { operation:'create', sessionName:SESSION, elementType:'Events', element: JSON.stringify({ 
                    subject: (mode==='call'?'Call: ':'Meeting: ')+desc.substring(0,25), description: desc, 
                    activitytype: (mode==='call'?'Call':'Meeting'), eventstatus: status, date_start: date, time_start: now.toTimeString().split(' ')[0], duration_hours:'0', parent_id: RECORD_ID, assigned_user_id: uid 
                })};
            }
            // USE WRITE_API_URL HERE
            const res = await fetch(WRITE_API_URL, { method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body: new URLSearchParams(payload) });
            const d = await res.json();
            if(d.success) {
                document.getElementById('act-desc').value=''; document.getElementById('mob-desc').value='';
                closeMobileDrawer(); loadTimeline();
            } else { alert("Error: "+JSON.stringify(d.error)); loadTimeline(); }
        } catch(e) { console.error(e); }
    }

    function postActivity() { postData(document.getElementById('act-desc').value.trim(), currentMode, document.getElementById('act-date').value, document.getElementById('act-status').value); }
    function postMobileActivity() { postData(document.getElementById('mob-desc').value.trim(), mobMode, new Date().toISOString().split('T')[0], 'Held'); }

    // UI HELPER FUNCTIONS
    function setMode(m) { 
        currentMode = m;
        ['comment','call','meeting'].forEach(x => { document.getElementById(`tab-${x}`).className = "flex-1 py-3 text-xs font-bold text-gray-500 hover:bg-gray-50 transition-all"; });
        document.getElementById(`tab-${m}`).className = "flex-1 py-3 text-xs font-bold text-indigo-600 border-b-2 border-indigo-600 bg-indigo-50/50 rounded-t-xl transition-all";
        const extras = document.getElementById('act-extras');
        if(m==='comment') { extras.classList.add('hidden'); document.getElementById('act-desc').placeholder = "Write a note..."; } 
        else { extras.classList.remove('hidden'); extras.classList.add('grid'); document.getElementById('act-desc').placeholder = `Result of ${m}...`; }
    }
    function setMobileMode(m) {
        mobMode = m;
        ['comment','call','meeting'].forEach(x => {
            const btn = document.getElementById(`mob-btn-${x}`);
            let color = (x==='call'?'green':(x==='meeting'?'orange':'indigo'));
            btn.className = (x===m) ? `flex flex-col items-center gap-2 p-3 rounded-2xl bg-${color}-50 text-${color}-600 border border-${color}-100 ring-2 ring-${color}-200 transition-all scale-105 shadow-sm` : "flex flex-col items-center gap-2 p-3 rounded-2xl bg-gray-50 text-gray-500 border border-gray-100 opacity-70 transition-all";
        });
        document.getElementById('mob-desc').placeholder = (m==='comment') ? "Write a note..." : `Result of ${m}...`;
    }
    function openMobileDrawer() { document.getElementById('mobile-drawer').classList.remove('hidden'); setTimeout(() => document.getElementById('drawer-content').classList.remove('translate-y-full'), 10); }
    function closeMobileDrawer() { document.getElementById('drawer-content').classList.add('translate-y-full'); setTimeout(() => document.getElementById('mobile-drawer').classList.add('hidden'), 300); }
    function setText(id, t) { const e=document.getElementById(id); if(e) e.innerText=t; }
    function goToEdit() { window.location.href=`manage.php?id=${RECORD_ID}`; }
    function triggerCall(id) { const p = document.getElementById(id).innerText; if(p && p!=='--') window.location.href=`tel:${p}`; }
    function getStatusClasses(s) {
        s = (s||'').toLowerCase();
        if(s.includes('hot')) return 'bg-red-50 text-red-600 border-red-100';
        if(s.includes('qualified')) return 'bg-green-50 text-green-600 border-green-100';
        if(s.includes('cold') || s.includes('junk')) return 'bg-gray-50 text-gray-500 border-gray-200';
        if(s.includes('contacted')) return 'bg-orange-50 text-orange-600 border-orange-100';
        return 'bg-blue-50 text-blue-600 border-blue-100';
    }
</script>

<style>
    @keyframes fadeUp { from { opacity:0; transform:translateY(10px); } to { opacity:1; transform:translateY(0); } }
    .animate-fade-in-up { animation: fadeUp 0.3s ease-out forwards; }
    .animate-fade-in { animation: fadeUp 0.2s ease-out forwards; }
</style>