<?php require_once '../../includes/header.php'; ?>

<div class="max-w-4xl mx-auto pb-24 md:pb-12 px-4 md:px-6 pt-6">

    <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-4 mb-6">
        <div>
            <nav class="flex text-[10px] font-bold text-gray-400 mb-2 uppercase tracking-wider">
                <a href="list.php" class="hover:text-indigo-600 transition-colors">Leads</a> 
                <span class="mx-2">/</span> 
                <span id="breadcrumb-action">Edit Lead</span>
            </nav>
            <h1 class="text-2xl font-extrabold text-navy-700" id="page-title">Loading...</h1>
        </div>
        <div class="flex gap-3 w-full md:w-auto">
             <button onclick="history.back()" class="flex-1 md:flex-none bg-white border border-gray-200 text-gray-600 px-5 py-2.5 rounded-xl text-xs font-bold hover:bg-gray-50">Cancel</button>
             <button onclick="saveRecord()" id="btn-save" class="flex-1 md:flex-none bg-navy-700 text-white px-8 py-2.5 rounded-xl text-xs font-bold hover:shadow-lg hover:shadow-navy-700/20 flex items-center justify-center gap-2">
                <i class="ph-bold ph-check"></i> Save Changes
            </button>
        </div>
    </div>

    <div class="flex overflow-x-auto pb-2 mb-4 gap-2 no-scrollbar">
        <button onclick="switchTab('sales')" id="tab-sales" class="tab-btn active-tab flex items-center gap-2 px-5 py-2.5 rounded-xl text-xs font-bold whitespace-nowrap transition-all">
            <i class="ph-bold ph-rocket-launch"></i> Sales Console
        </button>
        <button onclick="switchTab('contact')" id="tab-contact" class="tab-btn inactive-tab flex items-center gap-2 px-5 py-2.5 rounded-xl text-xs font-bold whitespace-nowrap transition-all">
            <i class="ph-bold ph-address-book"></i> Contact Info
        </button>
        <button onclick="switchTab('identity')" id="tab-identity" class="tab-btn inactive-tab flex items-center gap-2 px-5 py-2.5 rounded-xl text-xs font-bold whitespace-nowrap transition-all">
            <i class="ph-bold ph-fingerprint"></i> ID & Basic Info
        </button>
        <button onclick="switchTab('source')" id="tab-source" class="tab-btn inactive-tab flex items-center gap-2 px-5 py-2.5 rounded-xl text-xs font-bold whitespace-nowrap transition-all">
            <i class="ph-bold ph-tag"></i> Source Data <span id="source-lock-icon"><i class="ph-fill ph-lock-key text-[10px] opacity-50"></i></span>
        </button>
    </div>

    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-6 relative">
        <div id="loading-overlay" class="absolute inset-0 bg-white z-50 flex items-center justify-center rounded-2xl">
            <div class="w-8 h-8 border-4 border-indigo-100 border-t-indigo-600 rounded-full animate-spin"></div>
        </div>

        <form id="edit-form" class="space-y-6">
            
            <div id="content-sales" class="tab-content animate-fade-in">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    
                    <div class="space-y-1">
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wide">Lead Status <span class="text-red-500">*</span></label>
                        <select name="leadstatus" id="input-leadstatus" class="w-full bg-white border border-gray-200 text-gray-700 text-sm rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-100 outline-none font-bold"></select>
                    </div>
                    
                    <div class="space-y-1">
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wide">Interested Project</label>
                        <select name="cf_975" id="input-cf_975" class="w-full bg-white border border-gray-200 text-gray-700 text-sm rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-100 outline-none font-bold" onchange="triggerDependency('cf_975')"></select>
                    </div>

                    <div class="space-y-1">
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wide">Unit Type</label>
                        <select name="cf_979" id="input-cf_979" class="w-full bg-white border border-gray-200 text-gray-700 text-sm rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-100 outline-none"></select>
                    </div>
                    <div class="space-y-1">
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wide">Unit Specifications</label>
                        <select name="cf_981" id="input-cf_981" class="w-full bg-white border border-gray-200 text-gray-700 text-sm rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-100 outline-none"></select>
                    </div>

                    <div class="md:col-span-2 grid grid-cols-1 md:grid-cols-3 gap-4 bg-gray-50 rounded-xl p-4 border border-gray-100">
                        <div class="flex items-center gap-3 p-2">
                            <input type="checkbox" id="chk-cf_973" class="w-5 h-5 text-indigo-600 rounded focus:ring-indigo-500 border-gray-300">
                            <input type="hidden" name="cf_973" id="input-cf_973">
                            <label for="chk-cf_973" class="text-sm font-bold text-navy-700 cursor-pointer">Visited Us?</label>
                        </div>
                        <div class="flex items-center gap-3 p-2">
                            <input type="checkbox" id="chk-cf_2050" class="w-5 h-5 text-indigo-600 rounded focus:ring-indigo-500 border-gray-300" onchange="toggleOfferValue()">
                            <input type="hidden" name="cf_2050" id="input-cf_2050">
                            <label for="chk-cf_2050" class="text-sm font-bold text-navy-700 cursor-pointer">Offer Sent?</label>
                        </div>
                        <div class="p-1 opacity-50 transition-all" id="container-offer-val">
                            <label class="text-[10px] font-bold text-gray-400 uppercase">Offer Value</label>
                            <input type="text" name="cf_2998" id="input-cf_2998" class="w-full bg-white border border-gray-200 rounded-lg px-3 py-1.5 text-sm outline-none mt-1" disabled placeholder="EGP 0.00">
                        </div>
                    </div>

                    <div class="md:col-span-2 space-y-1">
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wide">Sales Notes</label>
                        <textarea name="description" id="input-description" rows="3" class="w-full bg-white border border-gray-200 text-gray-700 text-sm rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-100 outline-none" placeholder="Enter notes here..."></textarea>
                    </div>
                </div>
            </div>

            <div id="content-contact" class="tab-content hidden animate-fade-in">
                 <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="space-y-1">
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wide">Mobile Phone <span class="text-red-500">*</span></label>
                        <input type="text" name="mobile" id="input-mobile" class="w-full bg-white border border-gray-200 text-gray-700 text-sm rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-100 outline-none">
                    </div>
                    <div class="space-y-1">
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wide">Primary Phone <span id="lock-icon-phone"></span></label>
                        <input type="text" name="phone" id="input-phone" class="w-full bg-white border border-gray-200 text-gray-700 text-sm rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-100 outline-none transition-all">
                    </div>
                    <div class="space-y-1 md:col-span-2">
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wide">Email Address</label>
                        <input type="email" name="email" id="input-email" class="w-full bg-white border border-gray-200 text-gray-700 text-sm rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-100 outline-none">
                    </div>
                    <div class="md:col-span-2 pt-4 border-t border-gray-50">
                        <h4 class="text-xs font-extrabold text-navy-700 mb-4">Location</h4>
                        <div class="grid grid-cols-2 gap-4">
                            <input type="text" name="city" id="input-city" placeholder="City" class="bg-white border border-gray-200 rounded-xl px-4 py-3 text-sm outline-none">
                            <input type="text" name="country" id="input-country" placeholder="Country" class="bg-white border border-gray-200 rounded-xl px-4 py-3 text-sm outline-none">
                        </div>
                    </div>
                </div>
            </div>

            <div id="content-identity" class="tab-content hidden animate-fade-in">
                <div class="bg-blue-50 text-blue-600 px-4 py-3 rounded-xl text-xs font-bold mb-6 flex items-center gap-2 border border-blue-100">
                    <i class="ph-bold ph-info"></i> Basic info is locked once entered.
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="space-y-1">
                        <label class="text-[11px] font-bold text-gray-400 uppercase tracking-wide">First Name <i class="ph-fill ph-lock-key text-[10px]"></i> <span class="text-red-500">*</span></label>
                        <input type="text" name="firstname" id="input-firstname" class="w-full bg-white border border-gray-200 text-gray-700 text-sm rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-100 outline-none">
                    </div>
                    <div class="space-y-1">
                        <label class="text-[11px] font-bold text-gray-400 uppercase tracking-wide">Last Name <i class="ph-fill ph-lock-key text-[10px]"></i> <span class="text-red-500">*</span></label>
                        <input type="text" name="lastname" id="input-lastname" class="w-full bg-white border border-gray-200 text-gray-700 text-sm rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-100 outline-none">
                    </div>
                    
                    <div class="space-y-1">
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wide">Passport Number <span id="lock-icon-cf_965"></span></label>
                        <input type="text" name="cf_965" id="input-cf_965" class="w-full bg-white border border-gray-200 text-gray-700 text-sm rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-100 outline-none transition-all">
                    </div>

                    <div class="space-y-1">
                        <label class="text-[11px] font-bold text-gray-500 uppercase tracking-wide">National ID <span id="lock-icon-cf_1104"></span></label>
                        <input type="text" name="cf_1104" id="input-cf_1104" class="w-full bg-white border border-gray-200 text-gray-700 text-sm rounded-xl px-4 py-3 focus:ring-2 focus:ring-indigo-100 outline-none transition-all">
                    </div>
                </div>
            </div>

            <div id="content-source" class="tab-content hidden animate-fade-in">
                 <div class="bg-red-50 text-red-600 px-4 py-3 rounded-xl text-xs font-bold mb-6 flex items-center gap-2 border border-red-100" id="source-warning">
                    <i class="ph-bold ph-lock-key"></i> Source data cannot be modified.
                </div>
                 <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="space-y-1">
                        <label class="text-[11px] font-bold text-gray-400 uppercase tracking-wide">Lead Source <i class="ph-fill ph-lock-key text-[10px]" id="icon-leadsource"></i></label>
                        <select name="leadsource" id="input-leadsource" class="locked-input" onchange="triggerDependency('leadsource')"></select>
                    </div>
                    <div class="space-y-1">
                        <label class="text-[11px] font-bold text-gray-400 uppercase tracking-wide">Channel <i class="ph-fill ph-lock-key text-[10px]" id="icon-cf_971"></i></label>
                        <select name="cf_971" id="input-cf_971" class="locked-input" onchange="triggerDependency('cf_971')"></select>
                    </div>
                    <div class="space-y-1">
                        <label class="text-[11px] font-bold text-gray-400 uppercase tracking-wide">Lead Channel <i class="ph-fill ph-lock-key text-[10px]" id="icon-cf_969"></i></label>
                        <select name="cf_969" id="input-cf_969" class="locked-input"></select>
                    </div>
                </div>
            </div>

        </form>
    </div>
</div>

<style>
    .tab-btn { outline: none; }
    .active-tab { background-color: #312E81; color: white; box-shadow: 0 4px 6px -1px rgba(49, 46, 129, 0.2); }
    .inactive-tab { background-color: white; color: #6B7280; border: 1px solid #F3F4F6; }
    .inactive-tab:hover { background-color: #F9FAFB; color: #374151; }
    
    .locked-input { width: 100%; background-color: #F3F4F6; border: 1px solid #E5E7EB; color: #9CA3AF; font-size: 0.875rem; border-radius: 0.75rem; padding: 0.75rem 1rem; cursor: not-allowed; pointer-events: none; -webkit-appearance: none; }
    
    /* Standard Select Style (For unlocked fields) */
    select:not(.locked-input) { width: 100%; background-color: white; border: 1px solid #E5E7EB; color: #374151; font-size: 0.875rem; border-radius: 0.75rem; padding: 0.75rem 1rem; cursor: pointer; }
    select:not(.locked-input):focus { outline: none; border-color: #6366F1; box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1); }

    .cond-locked { background-color: #F9FAFB; color: #6B7280; border-color: #E5E7EB; pointer-events: none; }

    @keyframes fadeIn { from { opacity: 0; transform: translateY(5px); } to { opacity: 1; transform: translateY(0); } }
    .animate-fade-in { animation: fadeIn 0.2s ease-out forwards; }
    .no-scrollbar::-webkit-scrollbar { display: none; }
    .no-scrollbar { -ms-overflow-style: none; scrollbar-width: none; }
</style>

<script>
    const API_URL = 'direct_gateway.php';
    const SESSION = localStorage.getItem('vt_session');
    const USER_ID = localStorage.getItem('vt_userid');
    const RECORD_ID = new URLSearchParams(window.location.search).get('id');
    
    // Picklist fields
    const PICKLISTS = ['leadstatus', 'industry', 'cf_2992', 'cf_975', 'cf_979', 'cf_981', 'leadsource', 'cf_971', 'cf_969'];
    let DEPENDENCY_MAP = {}; // Store dependencies here

    document.addEventListener('DOMContentLoaded', async () => {
        if(!SESSION) { window.location.href='list.php'; return; }
        
        await Promise.all([loadPicklists(), loadDependencies()]);

        if(RECORD_ID) {
            document.getElementById('page-title').innerText = "Edit Lead";
            loadData();
        } else {
            // CREATION MODE
            document.getElementById('page-title').innerText = "Create New Lead";
            document.getElementById('breadcrumb-action').innerText = "Create";
            document.getElementById('loading-overlay').classList.add('hidden');
            
            // Unlock Source Fields for Creation
            unlockSourceFields();
            
            // Trigger dependencies for default values
            triggerDependency('cf_975');
            triggerDependency('leadsource');
        }
    });

    async function loadPicklists() {
        try {
            const res = await fetch(`${API_URL}?operation=describe&sessionName=${SESSION}&elementType=Leads`);
            const data = await res.json();
            if(data.success) {
                const fields = data.result.fields;
                PICKLISTS.forEach(pkey => {
                    const field = fields.find(f => f.name === pkey);
                    if(field && field.type.name === 'picklist') {
                        const sel = document.getElementById(`input-${pkey}`);
                        if(sel) {
                            sel.innerHTML = `<option value="">-- Select --</option>` + 
                                            field.type.picklistValues.map(v => `<option value="${v.value}">${v.label}</option>`).join('');
                            // Store all options in a data attribute for filtering later
                            sel.dataset.allOptions = JSON.stringify(field.type.picklistValues);
                        }
                    }
                });
            }
        } catch(e) { console.error(e); }
    }

    async function loadDependencies() {
        try {
            const res = await fetch(`${API_URL}?operation=get_dependencies`);
            const data = await res.json();
            if(data.success) {
                DEPENDENCY_MAP = data.result;
            }
        } catch(e) { console.error("Dep Error", e); }
    }

    // FILTER DROPDOWNS BASED ON SELECTION
    function triggerDependency(sourceField) {
        const sourceVal = document.getElementById(`input-${sourceField}`).value;
        
        if (!DEPENDENCY_MAP[sourceField]) return;

        // Loop through all targets controlled by this source
        Object.keys(DEPENDENCY_MAP[sourceField]).forEach(targetField => {
            const targetSelect = document.getElementById(`input-${targetField}`);
            if (!targetSelect) return;

            const allowedValues = DEPENDENCY_MAP[sourceField][targetField][sourceVal] || [];
            const allOptions = JSON.parse(targetSelect.dataset.allOptions || '[]');

            // Rebuild Options
            let html = `<option value="">-- Select --</option>`;
            allOptions.forEach(opt => {
                // If allowed or if no source value selected (reset), show option? 
                // Vtiger logic: if source selected, limit options. If source empty, usually clear target or show all.
                // Let's go with: Only show if in allowed list.
                if (allowedValues.includes(opt.value)) {
                    html += `<option value="${opt.value}">${opt.label}</option>`;
                }
            });
            targetSelect.innerHTML = html;
            targetSelect.value = ""; // Reset target value
        });
    }

    async function loadData() {
        try {
            const res = await fetch(`${API_URL}?operation=retrieve&sessionName=${SESSION}&id=${RECORD_ID}`);
            const data = await res.json();
            if(data.success) {
                const r = data.result;
                document.getElementById('page-title').innerText = `${r.firstname} ${r.lastname}`;
                
                Object.keys(r).forEach(key => {
                    const el = document.getElementById(`input-${key}`);
                    if(el) {
                        el.value = r[key];
                        // Trigger dependency to filter child fields, then set their value
                        if(DEPENDENCY_MAP[key]) {
                            triggerDependency(key);
                            // Re-set the child value after filtering
                            Object.keys(DEPENDENCY_MAP[key]).forEach(child => {
                                const childEl = document.getElementById(`input-${child}`);
                                if(childEl && r[child]) childEl.value = r[child];
                            });
                        }
                    }
                });

                if(document.getElementById('input-description')) document.getElementById('input-description').value = r.description || '';

                setCheckbox('cf_973', r.cf_973);  
                setCheckbox('cf_2050', r.cf_2050); 
                toggleOfferValue(); 

                conditionalLock('cf_965', r.cf_965); 
                conditionalLock('phone', r.phone);   
                
                // Edit Mode: Source is locked
                lockField('firstname');
                lockField('lastname');

                let idVal = r.cf_1104;
                if(idVal === '0') idVal = ''; 
                conditionalLock('cf_1104', idVal);
            }
        } catch(e) { console.error(e); }
        finally { document.getElementById('loading-overlay').classList.add('hidden'); }
    }

    function unlockSourceFields() {
        // Unlock functionality for Create Mode
        const sources = ['leadsource', 'cf_971', 'cf_969'];
        sources.forEach(fid => {
            const el = document.getElementById(`input-${fid}`);
            if(el) {
                el.classList.remove('locked-input');
                el.classList.remove('cond-locked');
                const icon = document.getElementById(`icon-${fid}`);
                if(icon) icon.className = "ph-bold ph-pencil-simple text-green-500 text-[10px]";
            }
        });
        document.getElementById('source-warning').className = "bg-green-50 text-green-600 px-4 py-3 rounded-xl text-xs font-bold mb-6 flex items-center gap-2 border border-green-100";
        document.getElementById('source-warning').innerHTML = '<i class="ph-bold ph-pencil-simple"></i> Set Source Data for New Lead';
        document.getElementById('source-lock-icon').innerHTML = ''; // Remove lock from tab
    }

    function conditionalLock(fieldId, value) {
        const input = document.getElementById(`input-${fieldId}`);
        const icon = document.getElementById(`lock-icon-${fieldId}`);
        if(value && value.trim() !== '') {
            input.readOnly = true; input.classList.add('cond-locked');
            if(icon) icon.innerHTML = '<i class="ph-fill ph-lock-key text-red-400 text-[10px]"></i>';
        } else {
            input.readOnly = false; input.classList.remove('cond-locked');
            if(icon) icon.innerHTML = '<i class="ph-bold ph-pencil-simple text-green-500 text-[10px]"></i>';
        }
    }
    
    function lockField(fid) {
        const el = document.getElementById(`input-${fid}`);
        if(el) { el.readOnly = true; el.classList.add('locked-input'); }
    }

    async function saveRecord() {
        const btn = document.getElementById('btn-save');
        btn.innerHTML = `<i class="ph-duotone ph-spinner animate-spin"></i> Saving...`;
        btn.disabled = true;

        try {
            const form = document.getElementById('edit-form');
            const formData = new FormData(form);
            let values = {};
            formData.forEach((value, key) => values[key] = value);

            if(RECORD_ID) values.id = RECORD_ID;
            values.assigned_user_id = USER_ID;
            if(!values.lastname) values.lastname = "Unknown"; 

            const res = await fetch(API_URL, {
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: new URLSearchParams({
                    operation: RECORD_ID ? 'update' : 'create',
                    sessionName: SESSION,
                    elementType: 'Leads',
                    element: JSON.stringify(values)
                })
            });

            const text = await res.text();
            try {
                const data = JSON.parse(text);
                if(data.success) {
                    window.location.href = `view.php?id=${data.result.id}`;
                } else {
                    alert("API Error: " + JSON.stringify(data.error));
                    btn.innerHTML = `<i class="ph-bold ph-check"></i> Save Changes`;
                    btn.disabled = false;
                }
            } catch(e) {
                console.error("Server Response:", text);
                alert("Server Error. Check console.");
                btn.innerHTML = `<i class="ph-bold ph-warning"></i> Error`;
                btn.disabled = false;
            }
        } catch(e) { 
            console.error(e); 
            btn.innerHTML = `<i class="ph-bold ph-check"></i> Save Changes`;
            btn.disabled = false;
        }
    }

    function setCheckbox(id, val) {
        const chk = document.getElementById(`chk-${id}`);
        const inp = document.getElementById(`input-${id}`);
        const isChecked = (val === '1' || val === 'on' || val === 'true');
        chk.checked = isChecked;
        inp.value = isChecked ? '1' : '0';
        chk.onclick = function() {
            inp.value = this.checked ? '1' : '0';
            if(id === 'cf_2050') toggleOfferValue();
        }
    }

    function toggleOfferValue() {
        const isSent = document.getElementById('chk-cf_2050').checked;
        const valInput = document.getElementById('input-cf_2998'); 
        const container = document.getElementById('container-offer-val');
        if(isSent) { valInput.disabled = false; container.classList.remove('opacity-50'); } 
        else { valInput.disabled = true; container.classList.add('opacity-50'); valInput.value = ''; }
    }

    function switchTab(tabName) {
        document.querySelectorAll('.tab-content').forEach(el => el.classList.add('hidden'));
        document.getElementById(`content-${tabName}`).classList.remove('hidden');
        document.querySelectorAll('.tab-btn').forEach(el => { el.classList.remove('active-tab'); el.classList.add('inactive-tab'); });
        const btn = document.getElementById(`tab-${tabName}`);
        btn.classList.remove('inactive-tab'); btn.classList.add('active-tab');
    }
</script>