<?php
// modules/leads/direct_gateway.php
// RESTORED: Uses your EXACT working SQL for the list.
// ADDED: Direct DB Picklists (Filtered) + Proxy for Saving.

// 1. Silent Mode (Safety Net)
ob_start();

header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *");

// 2. CONFIGURATION
$db_host = '92.205.180.58'; 
$db_name = 'helfaya'; 
$db_user = 'helfaya';       
$db_pass = 'Hel@2010';  
$crm_url = 'http://92.205.180.58/webservice.php';

// 3. ROUTER
$op = $_REQUEST['operation'] ?? '';

// A. If asking for Picklists -> Run New Logic
if ($op === 'get_picklists') {
    fetchPicklistsDirectly($db_host, $db_user, $db_pass, $db_name);
    exit;
}

// B. If Saving/Creating -> Run Proxy
if ($op !== '' && $op !== 'fetch_leads') {
    handleProxy($crm_url);
    exit;
}

// C. Otherwise -> Run YOUR WORKING List Logic
fetchLeadsMain($db_host, $db_user, $db_pass, $db_name);


// ====================================================
// SECTION A: YOUR WORKING LIST LOGIC (Restored)
// ====================================================
function fetchLeadsMain($host, $user, $pass, $db_name) {
    mysqli_report(MYSQLI_REPORT_OFF);
    $mysqli = @new mysqli($host, $user, $pass, $db_name);

    if ($mysqli->connect_error) {
        sendJson(['success'=>false, 'error'=>'db_connect_error']);
    }
    $mysqli->set_charset("utf8");

    $rawId = $_GET['userid'] ?? '';
    $parts = explode('x', $rawId);
    $userId = (int)end($parts);
    $scope = $_GET['scope'] ?? 'me'; 
    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 50;
    $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;

    if (!$userId) sendJson(['success'=>false, 'message'=>'No User ID']);

    // Permissions
    $ownerFilter = ""; 
    $adminCheck = $mysqli->query("SELECT is_admin FROM vtiger_users WHERE id = $userId");
    $isAdmin = ($adminCheck && $adminCheck->fetch_assoc()['is_admin'] === 'on');

    if (!$isAdmin) {
        $allowedIds = [$userId];
        if ($scope === 'team') {
            $allowedIds = array_merge($allowedIds, getAllSubordinates($mysqli, $userId));
        }
        $idList = implode(',', array_unique($allowedIds));
        $ownerFilter = "AND e.smownerid IN ($idList)";
    }

    // YOUR EXACT SQL
    $sql = "SELECT 
            l.leadid as id, l.lead_no, l.firstname, l.lastname, l.email, l.leadsource, l.leadstatus,
            COALESCE(a.phone, '') as phone, COALESCE(a.mobile, '') as mobile,
            cf.cf_975 as project, cf.cf_969 as lead_channel, cf.cf_971 as channel, 
            cf.cf_1139 as last_comment, cf.cf_2992 as system_status,
            e.smownerid, e.createdtime, e.modifiedtime,
            u.first_name, u.last_name, g.groupname
            FROM vtiger_leaddetails l
            INNER JOIN vtiger_crmentity e ON l.leadid = e.crmid
            LEFT JOIN vtiger_leadaddress a ON l.leadid = a.leadaddressid
            LEFT JOIN vtiger_leadscf cf ON l.leadid = cf.leadid 
            LEFT JOIN vtiger_users u ON e.smownerid = u.id
            LEFT JOIN vtiger_groups g ON e.smownerid = g.groupid
            WHERE e.deleted = 0 AND l.converted = 0 $ownerFilter 
            ORDER BY e.modifiedtime DESC LIMIT $offset, $limit";

    $result = $mysqli->query($sql);
    if (!$result) sendJson(['success'=>false, 'error'=>'query_failed']);

    $leads = [];
    $leadIds = [];

    while ($row = $result->fetch_assoc()) {
        $row['id'] = '10x' . $row['id'];
        
        // Strict Owner Logic
        if (!empty($row['groupname'])) {
            $row['assigned_user_id'] = $row['groupname'];
        } elseif (!empty($row['last_name'])) {
            $row['assigned_user_id'] = trim($row['first_name'] . ' ' . $row['last_name']);
        } else {
            $row['assigned_user_id'] = 'Unknown (' . $row['smownerid'] . ')';
        }
        
        $row['last_log_type'] = '';
        $row['last_log_date'] = '';
        $leads[$row['id']] = $row;
        $leadIds[] = $row['id'];
    }

    // Fetch Activity
    if (!empty($leadIds)) {
        $dbIds = array_map(function($id) { return explode('x', $id)[1]; }, $leadIds);
        $idStr = implode(',', $dbIds);
        $actSql = "SELECT parent_id, activitytype, date_start FROM vtiger_activity WHERE parent_id IN ($idStr) ORDER BY date_start ASC"; 
        $actRes = $mysqli->query($actSql);
        if($actRes) while($a = $actRes->fetch_assoc()) {
            $lid = '10x'.$a['parent_id'];
            if(isset($leads[$lid])) {
                $leads[$lid]['last_log_type'] = $a['activitytype'];
                $leads[$lid]['last_log_date'] = $a['date_start'];
            }
        }
    }

    sendJson(['success' => true, 'result' => array_values($leads)]);
    $mysqli->close();
}

// ====================================================
// SECTION B: NEW PICKLIST FETCHER (Direct DB + Filter)
// ====================================================
function fetchPicklistsDirectly($host, $user, $pass, $db_name) {
    mysqli_report(MYSQLI_REPORT_OFF);
    $mysqli = @new mysqli($host, $user, $pass, $db_name);
    if ($mysqli->connect_error) sendJson(['success'=>false]);
    $mysqli->set_charset("utf8mb4");

    // Map: Field Name -> DB Table
    $fields = [
        'leadstatus' => 'vtiger_leadstatus',
        'leadsource' => 'vtiger_leadsource',
        'industry'   => 'vtiger_industry',
        'cf_2992'    => 'vtiger_cf_2992', // System Status
        'cf_975'     => 'vtiger_cf_975',  // Project
        'cf_979'     => 'vtiger_cf_979',  // Unit Type
        'cf_981'     => 'vtiger_cf_981',  // Specs
        'cf_971'     => 'vtiger_cf_971',  // Channel
        'cf_969'     => 'vtiger_cf_969'   // Lead Channel
    ];

    $data = [];
    
    // 1. Get Values
    foreach ($fields as $field => $table) {
        // Query: Get values not deleted (if presence col exists) or just get all
        // Added FILTER: Not like 'Broker' or 'Option'
        $sql = "SELECT $field FROM $table WHERE $field NOT LIKE '%Broker%' AND $field NOT LIKE '%Option%' ORDER BY sortorderid";
        
        $res = $mysqli->query($sql);
        if ($res) {
            while ($row = $res->fetch_array()) {
                $val = $row[0];
                $data[$field][] = ['label' => $val, 'value' => $val];
            }
        }
    }

    // 2. Get Dependencies
    $deps = [];
    $dSql = "SELECT sourcefield, targetfield, sourcevalue, targetvalues FROM vtiger_picklist_dependency";
    $dRes = $mysqli->query($dSql);
    if($dRes) while($row = $dRes->fetch_assoc()) {
        $src = $row['sourcefield'];
        $trg = $row['targetfield'];
        $val = html_entity_decode($row['sourcevalue']);
        $targets = json_decode(html_entity_decode($row['targetvalues']), true);
        
        // Filter Dependencies too
        if(is_array($targets)) {
            $targets = array_filter($targets, function($t) { return (stripos($t,'Broker')===false && stripos($t,'Option')===false); });
            $deps[$src][$trg][$val] = array_values($targets);
        }
    }

    sendJson(['success' => true, 'picklists' => $data, 'dependencies' => $deps]);
    $mysqli->close();
}

// ====================================================
// SECTION C: PROXY & HELPERS
// ====================================================
function handleProxy($url) {
    ob_clean();
    $params = $_REQUEST;
    $ch = curl_init();
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        curl_setopt($ch, CURLOPT_URL, $url); curl_setopt($ch, CURLOPT_POST, true); curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
    } else {
        curl_setopt($ch, CURLOPT_URL, $url . '?' . http_build_query($params));
    }
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
    echo curl_exec($ch); curl_close($ch); exit;
}

function sendJson($data) { ob_clean(); echo json_encode($data, JSON_PARTIAL_OUTPUT_ON_ERROR); exit; }

function getAllSubordinates($db, $managerId) {
    $subs = [];
    $res = $db->query("SELECT id FROM vtiger_users WHERE reports_to_id = $managerId AND status='Active'");
    if ($res) while ($row = $res->fetch_assoc()) {
        $subs[] = $row['id'];
        $subs = array_merge($subs, getAllSubordinates($db, $row['id']));
    }
    return $subs;
}
?>