<?php require_once '../../includes/header.php'; ?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@18.1.1/build/css/intlTelInput.css">

<style>
    .view-card { background: white; border-radius: 1rem; padding: 1.5rem; border: 1px solid #E5E7EB; margin-bottom: 1.5rem; box-shadow: 0 1px 3px rgba(0,0,0,0.05); }
    @keyframes fadeUp { from { opacity:0; transform:translateY(10px); } to { opacity:1; transform:translateY(0); } }
    .animate-fade-in-up { animation: fadeUp 0.3s ease-out forwards; }
    #mobile-drawer { transition: opacity 0.3s ease-in-out; }
    #drawer-content { transition: transform 0.3s cubic-bezier(0.16, 1, 0.3, 1); }
</style>

<div class="max-w-7xl mx-auto pb-24 md:pb-12 px-4 md:px-6 pt-6">

    <div class="flex flex-col md:flex-row justify-between items-start md:items-center gap-4 mb-8 fade-in-up">
        <div>
            <nav class="flex text-[10px] font-bold text-gray-400 mb-2 uppercase tracking-wider">
                <a href="list.php" class="hover:text-indigo-600 transition-colors">Leads</a> <span class="mx-2">/</span> <span>Details</span>
            </nav>
            <div class="flex items-center gap-3">
                <h1 class="text-2xl md:text-3xl font-extrabold text-navy-700 tracking-tight" id="header-name">
                    <div class="h-8 w-48 bg-gray-100 rounded-lg animate-pulse"></div>
                </h1>
                <span id="header-status" class="hidden px-3 py-1 rounded-full text-[10px] font-extrabold uppercase tracking-wide border shadow-sm"></span>
            </div>
            <p class="text-xs text-gray-500 font-medium mt-1 flex items-center gap-2">
                <i class="ph-fill ph-identification-card"></i> <span id="header-no">#...</span>
                <span class="w-1 h-1 rounded-full bg-gray-300"></span>
                <span id="header-owner" class="text-indigo-600 font-bold">...</span>
            </p>
        </div>
        <div class="flex gap-3 w-full md:w-auto">
             <button onclick="history.back()" class="flex-1 md:flex-none bg-white border border-gray-200 text-gray-600 px-5 py-2.5 rounded-xl text-xs font-bold hover:bg-gray-50 transition-all shadow-sm"><i class="ph-bold ph-arrow-left"></i> Back</button>
             <button onclick="goToEdit()" class="flex-1 md:flex-none bg-navy-700 text-white px-6 py-2.5 rounded-xl text-xs font-bold hover:shadow-lg hover:shadow-navy-700/20 transition-all shadow-md flex items-center justify-center gap-2"><i class="ph-bold ph-pencil-simple"></i> Edit Lead</button>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 lg:gap-8">

        <div class="lg:col-span-1 space-y-6">
            <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 relative overflow-hidden group hover:shadow-md transition-all duration-300">
                <div class="absolute top-0 right-0 p-5 opacity-[0.03] group-hover:opacity-[0.06] transition-opacity"><i class="ph-fill ph-user-circle text-9xl text-indigo-900"></i></div>
                <h3 class="text-xs font-extrabold text-gray-400 uppercase tracking-wide mb-5">Contact Info</h3>
                <div class="space-y-5 relative z-10">
                    <div class="flex items-center gap-4 cursor-pointer" onclick="triggerCall('val-mobile')">
                        <div class="w-10 h-10 rounded-xl bg-green-50 text-green-600 flex items-center justify-center text-lg shadow-sm border border-green-100"><i class="ph-fill ph-phone"></i></div>
                        <div class="flex-1"><p class="text-[10px] font-bold text-gray-400 uppercase">Mobile</p><p class="text-sm font-bold text-navy-700 break-all" id="val-mobile">--</p></div>
                    </div>
                    <div class="flex items-center gap-4">
                        <div class="w-10 h-10 rounded-xl bg-gray-50 text-gray-500 flex items-center justify-center text-lg shadow-sm border border-gray-100"><i class="ph-fill ph-phone-call"></i></div>
                        <div class="flex-1"><p class="text-[10px] font-bold text-gray-400 uppercase">Primary Phone</p><p class="text-sm font-bold text-navy-700 break-all" id="val-phone">--</p></div>
                    </div>
                    <div class="flex items-center gap-4">
                        <div class="w-10 h-10 rounded-xl bg-blue-50 text-blue-600 flex items-center justify-center text-lg shadow-sm border border-blue-100"><i class="ph-fill ph-envelope-simple"></i></div>
                        <div class="flex-1 overflow-hidden"><p class="text-[10px] font-bold text-gray-400 uppercase">Email</p><p class="text-sm font-bold text-navy-700 truncate" id="val-email">--</p></div>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100 hover:shadow-md transition-all duration-300">
                <h3 class="text-xs font-extrabold text-gray-400 uppercase tracking-wide mb-4">Classification</h3>
                <div class="space-y-3">
                    <div class="flex justify-between items-center py-2 border-b border-gray-50"><span class="text-xs font-medium text-gray-500">Project</span><span class="text-xs font-bold text-indigo-600 bg-indigo-50 px-2 py-1 rounded-lg" id="val-project">--</span></div>
                    <div class="flex justify-between items-center py-2 border-b border-gray-50"><span class="text-xs font-medium text-gray-500">Unit Type</span><span class="text-xs font-bold text-navy-700" id="val-unit-type">--</span></div>
                    <div class="flex justify-between items-center py-2 border-b border-gray-50"><span class="text-xs font-medium text-gray-500">Specs</span><span class="text-xs font-bold text-navy-700" id="val-unit-specs">--</span></div>
                    <div class="flex justify-between items-center py-2 border-b border-gray-50"><span class="text-xs font-medium text-gray-500">Channel</span><span class="text-xs font-bold text-navy-700" id="val-channel">--</span></div>
                    <div class="flex justify-between items-center py-2 border-b border-gray-50"><span class="text-xs font-medium text-gray-500">Source</span><span class="text-xs font-bold text-navy-700" id="val-source">--</span></div>
                    <div class="flex justify-between items-center py-2 border-b border-gray-50"><span class="text-xs font-medium text-gray-500">System Status</span><span class="text-xs font-bold text-gray-700" id="val-sys-status">--</span></div>
                </div>
            </div>

            <div class="bg-white rounded-2xl p-6 shadow-sm border border-gray-100">
                <h3 class="text-xs font-extrabold text-gray-400 uppercase tracking-wide mb-3">Latest Interaction</h3>
                <div id="latest-log-area" class="bg-gray-50 rounded-xl p-3 border border-gray-100">
                    <p class="text-xs text-gray-400 italic">Loading...</p>
                </div>
            </div>
        </div>

        <div class="lg:col-span-2">
            <div class="hidden md:block bg-white rounded-2xl shadow-sm border border-gray-100 p-1 mb-8">
                <div class="flex border-b border-gray-100">
                    <button onclick="setMode('comment')" id="tab-comment" class="flex-1 py-3 text-xs font-bold text-indigo-600 border-b-2 border-indigo-600 bg-indigo-50/50 transition-all rounded-t-xl"><i class="ph-bold ph-chat-text"></i> Note</button>
                    <button onclick="setMode('call')" id="tab-call" class="flex-1 py-3 text-xs font-bold text-gray-500 hover:bg-gray-50 transition-all"><i class="ph-bold ph-phone"></i> Log Call</button>
                    <button onclick="setMode('meeting')" id="tab-meeting" class="flex-1 py-3 text-xs font-bold text-gray-500 hover:bg-gray-50 transition-all"><i class="ph-bold ph-users"></i> Meeting</button>
                </div>
                <div class="p-4">
                    <textarea id="act-desc" rows="3" class="w-full bg-gray-50 border-0 rounded-xl p-4 text-sm outline-none resize-none focus:ring-2 focus:ring-indigo-100 transition-all" placeholder="Write a note..."></textarea>
                    <div id="act-extras" class="hidden grid-cols-2 gap-3 mt-3 animate-fade-in">
                        <input type="date" id="act-date" class="bg-gray-50 rounded-xl px-3 py-2 text-xs font-bold border-0 outline-none text-gray-600">
                        <select id="act-status" class="bg-gray-50 rounded-xl px-3 py-2 text-xs font-bold border-0 outline-none text-gray-600">
                            <option value="Held">Held (Completed)</option>
                            <option value="Planned">Planned (Future)</option>
                        </select>
                    </div>
                    <div class="flex justify-between items-center mt-3">
                        <span class="text-[10px] font-bold text-gray-400 uppercase tracking-wide" id="act-label">New Note</span>
                        <button onclick="postActivity()" id="btn-post" class="bg-navy-700 text-white px-6 py-2 rounded-xl text-xs font-bold shadow-lg hover:shadow-navy-700/40 transition-all transform hover:-translate-y-0.5">Post Activity</button>
                    </div>
                </div>
            </div>

            <div class="flex items-center justify-between mb-5 px-1">
                <h3 class="text-sm font-extrabold text-navy-700 flex items-center gap-2"><i class="ph-bold ph-clock-counter-clockwise text-indigo-500"></i> History</h3>
                <button onclick="loadTimeline()" class="w-8 h-8 rounded-full bg-white border border-gray-200 text-gray-400 hover:text-indigo-600 flex items-center justify-center transition-all shadow-sm"><i class="ph-bold ph-arrows-clockwise"></i></button>
            </div>

            <div id="timeline-container" class="space-y-4 relative pb-20">
                <div id="timeline-loader" class="hidden py-10 text-center"><div class="inline-block w-8 h-8 border-4 border-indigo-100 border-t-indigo-600 rounded-full animate-spin"></div></div>
            </div>
        </div>
    </div>
</div>

<button onclick="openMobileDrawer()" class="md:hidden fixed bottom-6 right-6 w-14 h-14 bg-indigo-600 text-white rounded-full shadow-2xl shadow-indigo-600/40 flex items-center justify-center text-2xl z-50 hover:scale-105 active:scale-95 transition-all"><i class="ph-bold ph-plus"></i></button>
<div id="mobile-drawer" class="fixed inset-0 z-[60] hidden">
    <div class="absolute inset-0 bg-black/50 backdrop-blur-sm transition-opacity" onclick="closeMobileDrawer()"></div>
    <div class="absolute bottom-0 left-0 right-0 bg-white rounded-t-[32px] p-6 shadow-2xl transform transition-transform translate-y-full duration-300 ease-out" id="drawer-content">
        <h3 class="text-lg font-extrabold text-navy-700 mb-4">Log Activity</h3>
        <div class="grid grid-cols-3 gap-3 mb-4">
             <button onclick="setMobileMode('comment')" id="mob-btn-comment" class="flex flex-col items-center gap-2 p-3 rounded-2xl bg-indigo-50 text-indigo-600 border border-indigo-100 ring-2 ring-indigo-200"><i class="ph-fill ph-chat-text text-xl"></i> <span class="text-[10px] font-bold">Note</span></button>
             <button onclick="setMobileMode('call')" id="mob-btn-call" class="flex flex-col items-center gap-2 p-3 rounded-2xl bg-gray-50 text-gray-500 border border-gray-100"><i class="ph-fill ph-phone text-xl"></i> <span class="text-[10px] font-bold">Call</span></button>
             <button onclick="setMobileMode('meeting')" id="mob-btn-meeting" class="flex flex-col items-center gap-2 p-3 rounded-2xl bg-gray-50 text-gray-500 border border-gray-100"><i class="ph-fill ph-users text-xl"></i> <span class="text-[10px] font-bold">Meet</span></button>
        </div>
        <textarea id="mob-desc" rows="3" class="w-full bg-gray-50 border-0 rounded-xl p-4 text-sm outline-none resize-none mb-4 focus:ring-2 focus:ring-indigo-100 transition-all" placeholder="Write a note..."></textarea>
        <button onclick="postMobileActivity()" class="w-full bg-navy-700 text-white py-3.5 rounded-xl text-sm font-bold shadow-lg">Submit</button>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@18.1.1/build/js/intlTelInput.min.js"></script>

<script>
    const API_URL = 'direct_gateway.php';
    const WRITE_API_URL = 'save_lead.php'; 
    const SESSION = localStorage.getItem('vt_session');
    const RECORD_ID = new URLSearchParams(window.location.search).get('id');
    let userMap = JSON.parse(localStorage.getItem('vt_umap_v7') || '{}');
    let currentMode = 'comment';
    let mobMode = 'comment';

    document.addEventListener('DOMContentLoaded', async () => {
        if(!SESSION || !RECORD_ID) { window.location.href='list.php'; return; }
        
        loadDetails();
        loadTimeline(); 
        document.getElementById('act-date').valueAsDate = new Date();
    });

    async function loadDetails() {
        try {
            const res = await fetch(`${API_URL}?operation=retrieve&sessionName=${SESSION}&id=${RECORD_ID}`);
            const data = await res.json();
            if(data.success) {
                const l = data.result;
                setText('header-name', `${l.firstname} ${l.lastname}`);
                setText('header-no', `#${l.lead_no}`);
                
                const status = l.leadstatus || 'New';
                const sBadge = document.getElementById('header-status');
                sBadge.innerText = status;
                sBadge.className = `hidden md:inline-block px-3 py-1 rounded-full text-[10px] font-extrabold uppercase border shadow-sm ${getStatusClasses(status)}`;
                sBadge.classList.remove('hidden');

                setText('val-mobile', l.mobile); setText('val-phone', l.phone); setText('val-email', l.email);
                setText('val-project', l.cf_975); setText('val-channel', l.cf_971); setText('val-source', l.leadsource);
                setText('header-owner', l.assigned_user_id); setText('val-owner', l.assigned_user_id);
            }
        } catch(e) { console.error(e); }
    }

    async function loadTimeline() {
        const c = document.getElementById('timeline-container');
        const l = document.getElementById('timeline-loader');
        
        if(l) l.classList.remove('hidden');
        if(c) c.innerHTML = ''; 
        if(l && c) c.appendChild(l); 

        try {
            // New direct history fetch
            const res = await fetch(`${API_URL}?operation=fetch_history&id=${RECORD_ID}&t=${new Date().getTime()}`);
            const data = await res.json();
            
            if(l) l.classList.add('hidden');

            const latestBox = document.getElementById('latest-log-area');
            if(data.success && data.result.length > 0) {
                const last = data.result[0];
                const lType = last.type === 'note' ? 'Note' : last.subtype;
                const lTxt = last.type === 'note' ? last.content : last.content;
                latestBox.innerHTML = `<div class="flex items-center gap-2 mb-1"><span class="px-2 py-0.5 bg-gray-200 text-gray-600 rounded text-[10px] font-bold uppercase">${lType}</span><span class="text-[10px] text-gray-400">${new Date(last.date).toLocaleDateString()}</span></div><p class="text-xs font-bold text-navy-700 line-clamp-2">"${lTxt}"</p>`;
            } else {
                latestBox.innerHTML = `<p class="text-xs text-gray-400 italic">No interaction.</p>`;
            }

            if(!data.success || data.result.length === 0) {
                c.insertAdjacentHTML('beforeend', `<div class="text-center text-gray-400 py-10 bg-gray-50 rounded-2xl border border-dashed border-gray-200"><p class="text-xs font-bold">No history found.</p></div>`);
                return;
            }

            data.result.forEach(item => {
                const isNote = item.type === 'note';
                let icon = isNote ? 'ph-chat-text' : (item.subtype==='Call'?'ph-phone':'ph-users');
                let color = isNote ? 'indigo' : (item.subtype==='Call'?'green':'orange');

                c.insertAdjacentHTML('beforeend', `
                    <div class="relative z-10 flex gap-4 group animate-fade-in-up">
                        <div class="hidden md:flex w-12 h-12 rounded-full border-4 border-gray-50 bg-${color}-50 text-${color}-600 items-center justify-center text-xl shadow-sm z-10">
                            <i class="ph-fill ${icon}"></i>
                        </div>
                        <div class="flex-1 bg-white rounded-2xl p-5 border border-gray-100 shadow-sm group-hover:shadow-md transition-all">
                            <div class="flex justify-between items-start mb-2">
                                <div>
                                    <h4 class="text-sm font-bold text-navy-700">${isNote ? 'Note' : item.content}</h4>
                                    <p class="text-[10px] text-gray-400 font-bold uppercase tracking-wide">
                                        ${item.owner} • ${new Date(item.date).toLocaleString()}
                                    </p>
                                </div>
                                ${!isNote ? `<span class="px-2 py-0.5 rounded text-[10px] font-bold uppercase bg-gray-100 text-gray-500">${item.status}</span>` : ''}
                            </div>
                            <p class="text-sm text-gray-600 leading-relaxed whitespace-pre-wrap">${isNote ? item.content : (item.desc||'No description')}</p>
                        </div>
                    </div>
                `);
            });
        } catch(e) { 
            console.error("Timeline Error:", e);
            if(l) l.classList.add('hidden');
        }
    }

    async function postData(desc, mode, date, status) {
        if(!desc) return alert("Please type something.");
        
        const tempId = 'temp-load-' + Date.now();
        const c = document.getElementById('timeline-container');
        c.insertAdjacentHTML('afterbegin', `<div id="${tempId}" class="bg-indigo-50 border border-indigo-100 p-4 rounded-xl text-center text-indigo-600 text-xs font-bold animate-pulse mb-4">Posting...</div>`);
        
        try {
            let payload = {};
            const uid = localStorage.getItem('vt_userid');
            if(mode==='comment') {
                payload = { operation:'create', sessionName:SESSION, elementType:'ModComments', element: JSON.stringify({ commentcontent:desc, related_to:RECORD_ID, assigned_user_id:uid }) };
            } else {
                const now = new Date();
                const start = now.toTimeString().split(' ')[0];
                const end = new Date(now.getTime() + 5*60000).toTimeString().split(' ')[0];
                payload = { operation:'create', sessionName:SESSION, elementType:'Events', element: JSON.stringify({ subject: (mode==='call'?'Call: ':'Meeting: ')+desc.substring(0,25), description: desc, activitytype: (mode==='call'?'Call':'Meeting'), eventstatus: status, date_start: date, due_date: date, time_start: start, time_end: end, duration_hours:'0', parent_id: RECORD_ID, assigned_user_id: uid }) };
            }
            
            const res = await fetch(WRITE_API_URL, { method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body: new URLSearchParams(payload) });
            const d = await res.json();
            
            const tempEl = document.getElementById(tempId);
            if(tempEl) tempEl.remove();

            if(d.success) {
                document.getElementById('act-desc').value=''; document.getElementById('mob-desc').value='';
                closeMobileDrawer(); 
                setTimeout(loadTimeline, 1000); 
            } else { alert("Error: "+JSON.stringify(d.error)); }
        } catch(e) { 
            const tempEl = document.getElementById(tempId);
            if(tempEl) tempEl.remove();
            console.error(e); 
        }
    }

    function setText(id, t) { const e=document.getElementById(id); if(e) e.innerText=(t&&t!=='')?t:'--'; }
    function goToEdit() { window.location.href=`manage.php?id=${RECORD_ID}`; }
    function triggerCall(id) { const p = document.getElementById(id).innerText; if(p && p!=='--') window.location.href=`tel:${p}`; }
    function getStatusClasses(s) { s=(s||'').toLowerCase(); if(s.includes('hot'))return 'bg-red-50 text-red-600 border-red-100'; return 'bg-blue-50 text-blue-600 border-blue-100'; }
    
    function postActivity() { postData(document.getElementById('act-desc').value.trim(), currentMode, document.getElementById('act-date').value, document.getElementById('act-status').value); }
    function postMobileActivity() { postData(document.getElementById('mob-desc').value.trim(), mobMode, new Date().toISOString().split('T')[0], 'Held'); }
    function setMode(m) { currentMode = m; ['comment','call','meeting'].forEach(x => document.getElementById(`tab-${x}`).className = "flex-1 py-3 text-xs font-bold text-gray-500 hover:bg-gray-50 transition-all"); document.getElementById(`tab-${m}`).className = "flex-1 py-3 text-xs font-bold text-indigo-600 border-b-2 border-indigo-600 bg-indigo-50/50 rounded-t-xl transition-all"; const ex = document.getElementById('act-extras'); if(m==='comment') ex.classList.add('hidden'); else ex.classList.remove('hidden'); }
    function setMobileMode(m) { mobMode = m; ['comment','call','meeting'].forEach(x => { const btn = document.getElementById(`mob-btn-${x}`); let color = (x==='call'?'green':(x==='meeting'?'orange':'indigo')); btn.className = (x===m) ? `flex flex-col items-center gap-2 p-3 rounded-2xl bg-${color}-50 text-${color}-600 border border-${color}-100 ring-2 ring-${color}-200 transition-all scale-105 shadow-sm` : "flex flex-col items-center gap-2 p-3 rounded-2xl bg-gray-50 text-gray-500 border border-gray-100 opacity-70 transition-all"; }); document.getElementById('mob-desc').placeholder = (m==='comment') ? "Write a note..." : `Result of ${m}...`; }
    function openMobileDrawer() { document.getElementById('mobile-drawer').classList.remove('hidden'); setTimeout(() => document.getElementById('drawer-content').classList.remove('translate-y-full'), 10); }
    function closeMobileDrawer() { document.getElementById('drawer-content').classList.add('translate-y-full'); setTimeout(() => document.getElementById('mobile-drawer').classList.add('hidden'), 300); }
</script>