<?php
// modules/leads/save_lead.php
// FIXED: Now accepts dynamic 'elementType' (Leads, Events, ModComments)
// PREVIOUSLY: Hardcoded to 'Leads', causing errors when creating Events/Comments

while (ob_get_level()) ob_end_clean();
ob_start();

header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *");

$crm_url = 'https://peopleandplaceseg.com/crm/webservice.php';

// 2. Validate Inputs
$op = $_POST['operation'] ?? '';
$session = $_POST['sessionName'] ?? '';
$element = $_POST['element'] ?? '';
$type = $_POST['elementType'] ?? 'Leads'; // FIXED: Get type from POST, default to Leads

if (!$op || !$session || !$element) {
    echo json_encode(['success' => false, 'error' => 'Missing POST parameters']);
    exit;
}

// 3. Execute Request
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $crm_url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
    'operation' => $op,
    'sessionName' => $session,
    'elementType' => $type, // FIXED: Use the dynamic type (Events/Leads/etc)
    'element' => $element
]));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);  

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
curl_close($ch);

// 4. Handle CURL Network Errors
if ($response === false) {
    ob_clean();
    echo json_encode(['success' => false, 'error' => 'CURL Failed: ' . $curl_error]);
    exit;
}

// 5. Try to Decode JSON
$json = json_decode($response, true);

ob_clean(); 

if (json_last_error() === JSON_ERROR_NONE) {
    echo $response; 
} else {
    $clean_raw = strip_tags($response); 
    if (trim($response) === '') {
        $clean_raw = "Empty Response from Vtiger (HTTP $http_code)";
    }
    echo json_encode([
        'success' => false, 
        'error' => 'SERVER ERROR: ' . $clean_raw,
        'full_response' => $response 
    ]);
}
exit;
?>