<?php require_once '../../includes/header.php'; ?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@18.1.1/build/css/intlTelInput.css">

<style>
    /* View-Like Layout */
    .view-card { background: white; border-radius: 1rem; padding: 1.5rem; border: 1px solid #E5E7EB; margin-bottom: 1.5rem; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1); }
    .view-header { font-size: 0.75rem; font-weight: 800; color: #9CA3AF; text-transform: uppercase; margin-bottom: 1rem; letter-spacing: 0.05em; }
    .input-group { margin-bottom: 1rem; }
    .input-label { display: block; font-size: 0.75rem; font-weight: 700; color: #6B7280; margin-bottom: 0.25rem; text-transform: uppercase; }
    .std-input { width: 100%; border: 1px solid #E5E7EB; border-radius: 0.5rem; padding: 0.5rem 0.75rem; font-size: 0.875rem; outline: none; transition: all 0.2s; font-weight: 600; color: #1F2937; }
    .std-input:focus { border-color: #10B981; box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1); }
    .select2-container .select2-selection--single { height: 38px !important; border-radius: 0.5rem !important; border: 1px solid #E5E7EB !important; }
    .select2-container--default .select2-selection--single .select2-selection__arrow { top: 6px !important; }
    .locked-input { background-color: #F3F4F6 !important; color: #6B7280 !important; pointer-events: none; border-color: #E5E7EB; }
    .iti { width: 100%; }
</style>

<div class="max-w-7xl mx-auto pb-32 px-4 md:px-6 pt-6">

    <div class="flex justify-between items-center mb-8">
        <div>
            <nav class="flex text-[10px] font-bold text-gray-400 mb-2 uppercase">
                <a href="list.php" class="hover:text-green-600">Leads</a> <span class="mx-2">/</span> <span>Edit</span>
            </nav>
            <h1 class="text-3xl font-extrabold text-navy-700" id="header-name">Loading...</h1>
            <p class="text-xs text-gray-500 font-bold mt-1" id="header-no">#...</p>
        </div>
        <div class="flex gap-3">
             <button onclick="history.back()" class="bg-white border border-gray-200 text-gray-600 px-5 py-2.5 rounded-xl text-xs font-bold hover:bg-gray-50">Cancel</button>
             <button onclick="saveChanges()" id="btn-save" class="bg-green-600 text-white px-6 py-2.5 rounded-xl text-xs font-bold hover:shadow-lg flex items-center gap-2"><i class="ph-bold ph-check"></i> Save Changes</button>
        </div>
    </div>

    <form id="edit-form">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 lg:gap-8">

            <div class="lg:col-span-1">
                <div class="view-card">
                    <h3 class="view-header">Contact Info</h3>
                    <div class="space-y-4">
                        <div class="input-group">
                            <label class="input-label">Primary Phone <span class="text-red-500">*</span></label>
                            <input type="tel" id="input-phone-flag" class="std-input">
                            <input type="hidden" name="phone" id="input-phone">
                        </div>
                        <div class="input-group">
                            <label class="input-label">Mobile</label>
                            <input type="tel" id="input-mobile-flag" class="std-input">
                            <input type="hidden" name="mobile" id="input-mobile">
                        </div>
                        <div class="input-group"><label class="input-label">Email</label><input type="email" name="email" id="input-email" class="std-input"></div>
                        <div class="grid grid-cols-2 gap-2">
                            <div class="input-group"><label class="input-label">City</label><input type="text" name="city" id="input-city" class="std-input"></div>
                            <div class="input-group"><label class="input-label">Country</label><input type="text" name="country" id="input-country" class="std-input"></div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="lg:col-span-1">
                <div class="view-card">
                    <h3 class="view-header">Identity</h3>
                    <div class="space-y-4">
                        <div class="input-group"><label class="input-label">First Name</label><input type="text" id="input-firstname" class="std-input locked-input" readonly></div>
                        <div class="input-group"><label class="input-label">Last Name</label><input type="text" id="input-lastname" class="std-input locked-input" readonly></div>
                        <div class="input-group"><label class="input-label">National ID</label><input type="text" name="cf_1104" id="input-cf_1104" class="std-input"></div>
                        <div class="input-group"><label class="input-label">Passport</label><input type="text" name="cf_965" id="input-cf_965" class="std-input"></div>
                    </div>
                </div>
                <div class="view-card">
                    <h3 class="view-header">Status</h3>
                    <div class="input-group"><label class="input-label">Lead Status</label><select name="leadstatus" id="input-leadstatus" class="select2-enable w-full"></select></div>
                </div>
            </div>

            <div class="lg:col-span-1">
                <div class="view-card">
                    <h3 class="view-header">Classification</h3>
                    <div class="space-y-4">
                        <div class="input-group"><label class="input-label">Project</label><select name="cf_975" id="input-cf_975" class="select2-enable w-full" onchange="triggerDependency('cf_975')"></select></div>
                        <div class="grid grid-cols-2 gap-2">
                            <div class="input-group"><label class="input-label">Unit Type</label><select name="cf_979" id="input-cf_979" class="select2-enable w-full"></select></div>
                            <div class="input-group"><label class="input-label">Specs</label><select name="cf_981" id="input-cf_981" class="select2-enable w-full"></select></div>
                        </div>
                        <div class="input-group"><label class="input-label">Channel (L1)</label><input type="text" id="disp-cf_971" class="std-input locked-input" readonly><input type="hidden" name="cf_971" id="input-cf_971"></div>
                        <div class="input-group"><label class="input-label">Lead Channel (L2)</label><input type="text" id="disp-cf_969" class="std-input locked-input" readonly><input type="hidden" name="cf_969" id="input-cf_969"></div>
                        <div class="input-group"><label class="input-label">Source (L3)</label><input type="text" id="disp-leadsource" class="std-input locked-input" readonly><input type="hidden" name="leadsource" id="input-leadsource"></div>
                    </div>
                </div>
                <div class="view-card">
                    <h3 class="view-header">Notes</h3>
                    <textarea name="description" id="input-description" rows="3" class="std-input h-auto"></textarea>
                </div>
            </div>

        </div>
    </form>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@18.1.1/build/js/intlTelInput.min.js"></script>

<script>
    const READ_URL = 'direct_gateway.php';
    const WRITE_URL = 'save_lead.php'; // NEW SEPARATE CONNECTION
    const SESSION = localStorage.getItem('vt_session');
    const RECORD_ID = new URLSearchParams(window.location.search).get('id');
    const PICKLISTS = ['leadstatus', 'cf_975', 'cf_979', 'cf_981']; 
    let DEPENDENCY_MAP = {}; let itiMobile, itiPhone;

    document.addEventListener('DOMContentLoaded', async () => {
        if(!RECORD_ID || !SESSION) { window.location.href='list.php'; return; }
        
        const opts = { utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@18.1.1/build/js/utils.js", initialCountry: "eg", preferredCountries: ["eg", "sa", "ae"], separateDialCode: true };
        itiMobile = window.intlTelInput(document.querySelector("#input-mobile-flag"), opts);
        itiPhone = window.intlTelInput(document.querySelector("#input-phone-flag"), opts);

        await loadMetadata();
        await loadData();
    });

    async function loadMetadata() {
        try {
            const res = await fetch(`${READ_URL}?operation=get_picklists`);
            const data = await res.json();
            if(data.success) {
                const lists = data.picklists;
                DEPENDENCY_MAP = data.dependencies;
                PICKLISTS.forEach(key => {
                    const el = document.getElementById(`input-${key}`);
                    if(el && lists[key]) {
                        el.dataset.allOptions = JSON.stringify(lists[key]);
                        let html = `<option value="">Select...</option>`;
                        lists[key].forEach(opt => html += `<option value="${opt.value}">${opt.label}</option>`);
                        el.innerHTML = html;
                    }
                });
                $('.select2-enable').select2({ width: '100%' });
            }
        } catch(e) {}
    }

    function triggerDependency(sourceField) {
        const sourceVal = $(`#input-${sourceField}`).val(); 
        if (!DEPENDENCY_MAP[sourceField]) return;
        Object.keys(DEPENDENCY_MAP[sourceField]).forEach(targetField => {
            const targetSelect = document.getElementById(`input-${targetField}`);
            if(!targetSelect || targetSelect.tagName !== 'SELECT') return; 
            const allOptions = JSON.parse(targetSelect.dataset.allOptions || '[]');
            const allowedValues = DEPENDENCY_MAP[sourceField][targetField][sourceVal];
            const currentVal = targetSelect.getAttribute('data-val'); 
            let html = `<option value="">Select...</option>`;
            if (allowedValues && allowedValues.length > 0) {
                allOptions.forEach(opt => { if (allowedValues.includes(opt.value)) { const selected = (opt.value == currentVal) ? 'selected' : ''; html += `<option value="${opt.value}" ${selected}>${opt.label}</option>`; } });
            } else if (!sourceVal) {
                allOptions.forEach(opt => { const selected = (opt.value == currentVal) ? 'selected' : ''; html += `<option value="${opt.value}" ${selected}>${opt.label}</option>`; });
            }
            targetSelect.innerHTML = html;
            $(`#input-${targetField}`).val(null).trigger('change.select2'); 
            if(DEPENDENCY_MAP[targetField]) triggerDependency(targetField); 
        });
    }

    async function loadData() {
        try {
            const res = await fetch(`${READ_URL}?operation=retrieve&id=${RECORD_ID}`);
            const data = await res.json();
            if(data.success) {
                const r = data.result;
                document.getElementById('header-name').innerText = `${r.firstname} ${r.lastname}`;
                document.getElementById('header-no').innerText = `#${r.lead_no}`;
                
                $('#input-email').val(r.email);
                $('#input-city').val(r.city);
                $('#input-country').val(r.country);
                $('#input-description').val(r.description);
                $('#input-firstname').val(r.firstname);
                $('#input-lastname').val(r.lastname);
                $('#input-cf_1104').val(r.cf_1104);
                $('#input-cf_965').val(r.cf_965);

                if(r.mobile) itiMobile.setNumber(r.mobile);
                if(r.phone) itiPhone.setNumber(r.phone);

                // LOCKING LOGIC
                if(r.phone && r.phone !== '0') {
                    document.getElementById('input-phone-flag').setAttribute('readonly', true);
                    document.getElementById('input-phone-flag').classList.add('locked-input');
                }
                if(r.cf_1104 && r.cf_1104 !== '0') {
                    document.getElementById('input-cf_1104').setAttribute('readonly', true);
                    document.getElementById('input-cf_1104').classList.add('locked-input');
                }
                if(r.cf_965 && r.cf_965 !== '0') {
                    document.getElementById('input-cf_965').setAttribute('readonly', true);
                    document.getElementById('input-cf_965').classList.add('locked-input');
                }

                // READ ONLY SOURCES
                $('#disp-cf_971').val(r.cf_971); $('#input-cf_971').val(r.cf_971);
                $('#disp-cf_969').val(r.cf_969); $('#input-cf_969').val(r.cf_969);
                $('#disp-leadsource').val(r.leadsource); $('#input-leadsource').val(r.leadsource);

                // VALUES & DEPENDENCIES
                $('#input-leadstatus').val(r.leadstatus).trigger('change');
                $('#input-cf_975').attr('data-val', r.cf_975).val(r.cf_975).trigger('change'); 
                triggerDependency('cf_975');
                
                setTimeout(() => {
                    if(r.cf_979) $('#input-cf_979').val(r.cf_979).trigger('change');
                    if(r.cf_981) $('#input-cf_981').val(r.cf_981).trigger('change');
                }, 300);
            }
        } catch(e) { console.error(e); }
    }

    async function saveChanges() {
        const btn = document.getElementById('btn-save'); 
        
        const pPhone = document.querySelector("#input-phone-flag");
        if (!pPhone.readOnly) {
             if(!pPhone.value.trim() || !itiPhone.isValidNumber()) { alert("Primary Phone is Invalid or Empty"); return; }
        }

        btn.innerHTML = `Saving...`; btn.disabled = true;
        try {
            const formData = new FormData(document.getElementById('edit-form'));
            let values = {};
            formData.forEach((value, key) => values[key] = value);
            PICKLISTS.forEach(k => values[k] = $(`#input-${k}`).val());
            
            values.mobile = itiMobile.getNumber(); 
            values.phone = itiPhone.getNumber(); 
            values.id = RECORD_ID;
            values.assigned_user_id = localStorage.getItem('vt_userid');

            const res = await fetch(WRITE_URL, { 
                method: 'POST', 
                headers: {'Content-Type': 'application/x-www-form-urlencoded'}, 
                body: new URLSearchParams({ operation: 'update', sessionName: SESSION, element: JSON.stringify(values) }) 
            });
            const data = await res.json();
            if(data.success) { window.location.href = `view.php?id=${data.result.id}`; }
            else { alert("Error: " + JSON.stringify(data.error)); btn.innerHTML = `Try Again`; btn.disabled = false; }
        } catch(e) { alert("Server Error"); btn.disabled = false; }
    }
</script>