<?php require_once '../../includes/header.php'; ?>

<div class="flex flex-col h-[calc(100vh-20px)] md:h-[calc(100vh-40px)] gap-4">

    <div class="md:hidden flex flex-col gap-2 bg-white/95 backdrop-blur-md p-3 shadow-md z-40 sticky top-0 rounded-2xl border border-gray-100 mx-3 mt-2">
        <div class="flex gap-2">
            <input type="text" id="mobPhone" onkeyup="mobSearch()" placeholder="Phone..." class="w-full px-4 py-2.5 bg-gray-50 rounded-xl text-xs border-0 ring-1 ring-gray-100 focus:ring-indigo-500">
            <input type="text" id="mobSource" onkeyup="mobSearch()" placeholder="Source..." class="w-full px-4 py-2.5 bg-gray-50 rounded-xl text-xs border-0 ring-1 ring-gray-100 focus:ring-indigo-500">
        </div>
        <div class="flex justify-between items-center px-1 pt-1">
             <span class="text-[10px] font-extrabold text-gray-400 uppercase tracking-wide bg-gray-100 px-2 py-1 rounded-full" id="mob-count">Loading...</span>
             <button onclick="window.location.href='manage.php'" class="bg-gradient-to-r from-blue-600 to-indigo-600 text-white px-4 py-1.5 rounded-lg text-xs font-bold shadow-lg shadow-blue-500/30">+ New</button>
        </div>
    </div>

    <div class="hidden md:flex bg-white p-3 rounded-[20px] shadow-sm flex-row justify-between items-center gap-4 flex-shrink-0 z-20 border border-gray-100 mx-4 mt-4">
        <div class="flex items-center gap-4">
             <div class="bg-indigo-50 p-2 rounded-xl text-indigo-600"><i class="ph-bold ph-users-three text-xl"></i></div>
             <div><h2 class="text-lg font-extrabold text-navy-700">Leads Manager</h2><p class="text-[10px] text-gray-400 font-bold" id="record-count">Loading...</p></div>
        </div>
        <div class="flex gap-2">
             <select id="pageSize" onchange="changeSize()" class="bg-gray-50 px-3 py-2 rounded-xl text-xs font-bold text-navy-700 border-0 cursor-pointer hover:bg-gray-100 outline-none">
                <option value="20">20 Rows</option><option value="50">50 Rows</option><option value="100">100 Rows</option>
             </select>
             <div class="relative">
                <button onclick="toggleColumnMenu(event)" class="bg-white border border-gray-200 text-gray-600 px-3 py-2 rounded-xl text-xs font-bold hover:border-indigo-400 hover:text-indigo-600 transition-all flex items-center gap-2"><i class="ph-bold ph-columns"></i> Cols</button>
                <div id="column-manager-menu" class="hidden absolute top-12 right-0 w-64 bg-white rounded-2xl shadow-xl border border-gray-100 p-4 max-h-80 overflow-y-auto z-50">
                    <div class="flex justify-between items-center mb-3"><span class="text-xs font-bold text-gray-400 uppercase">Fields</span><button onclick="restoreDefaults()" class="text-[10px] text-indigo-500 font-bold hover:underline">Reset</button></div><div id="column-list" class="space-y-2"></div>
                </div>
             </div>
             <button onclick="resetFilters()" class="w-9 h-9 bg-gray-50 hover:bg-gray-100 text-gray-500 rounded-xl flex items-center justify-center transition-all"><i class="ph-bold ph-arrow-counter-clockwise text-lg"></i></button>
             <button onclick="window.location.href='create.php'" class="bg-gradient-to-r from-blue-600 to-indigo-600 hover:shadow-lg hover:shadow-blue-500/40 text-white px-5 py-2 rounded-xl text-xs font-bold transition-all flex items-center gap-2"><i class="ph-bold ph-plus"></i> New Lead</button>
        </div>
    </div>

    <div class="mx-3 md:mx-4 bg-white rounded-[20px] shadow-sm flex flex-col flex-1 overflow-hidden border border-gray-100 relative">
        <div class="overflow-auto flex-1 w-full p-0 scroll-smooth" id="table-container">
            <div class="hidden md:block">
                <table class="w-full text-left border-collapse">
                    <thead class="bg-gray-50/90 backdrop-blur sticky top-0 z-10 text-xs font-bold text-gray-500 uppercase tracking-wide border-b border-gray-100">
                        <tr id="table-header-row"></tr>
                    </thead>
                    <tbody id="leads-table-body" class="text-sm font-medium text-gray-600 divide-y divide-gray-50 bg-white"></tbody>
                </table>
            </div>

            <div id="mobile-card-container" class="md:hidden flex flex-col gap-3 p-3 pb-20"></div>

            <div id="loading-state" class="flex flex-col items-center justify-center h-48">
                <div class="w-8 h-8 border-4 border-indigo-200 border-t-indigo-600 rounded-full animate-spin"></div>
                <p class="text-[10px] text-indigo-600 font-bold mt-2">Syncing DB...</p>
            </div>
            <div id="empty-state" class="hidden flex flex-col items-center justify-center h-48 text-gray-400">
                <i class="ph-duotone ph-folder-open text-4xl mb-2"></i>
                <p class="text-sm font-bold">No leads found</p>
            </div>
        </div>

        <div class="p-2 border-t border-gray-100 flex justify-between items-center bg-gray-50">
            <span class="text-[10px] text-gray-500 font-bold ml-2" id="page-info">Page 1</span>
            <div class="flex gap-1">
                <button id="p-prev" onclick="changePage(-1)" disabled class="w-8 h-8 flex items-center justify-center bg-white border border-gray-200 rounded-lg disabled:opacity-50 hover:bg-white"><i class="ph-bold ph-caret-left"></i></button>
                <button id="p-next" onclick="changePage(1)" class="w-8 h-8 flex items-center justify-center bg-white border border-gray-200 rounded-lg disabled:opacity-50 hover:bg-white"><i class="ph-bold ph-caret-right"></i></button>
            </div>
        </div>
    </div>
</div>

<div id="filter-popover" class="hidden absolute bg-white p-4 rounded-xl shadow-2xl border border-gray-100 w-64 z-50 animate-fade-in-down">
    <div class="flex justify-between items-center mb-3">
        <span class="text-xs font-bold text-gray-500 uppercase">Filter</span>
        <button onclick="closeFilterPopup()" class="text-gray-400 hover:text-red-500"><i class="ph-bold ph-x"></i></button>
    </div>
    <select id="filter-operator" class="w-full text-xs bg-gray-50 border border-gray-200 rounded-lg px-3 py-2 mb-2 focus:border-horizon-500 outline-none">
        <option value="contains">Contains</option><option value="eq">Equals (=)</option><option value="starts">Starts With</option>
    </select>
    <input type="text" id="filter-value" placeholder="Value..." class="w-full text-sm bg-white border border-gray-200 rounded-lg px-3 py-2 mb-4 focus:border-horizon-500 outline-none">
    <div class="flex gap-2">
        <button onclick="applyFilter()" class="flex-1 bg-indigo-600 text-white py-2 rounded-lg text-xs font-bold">Apply</button>
        <button onclick="clearCurrentFilter()" class="px-3 bg-gray-100 text-gray-600 py-2 rounded-lg text-xs font-bold">Clear</button>
    </div>
</div>

<script>
    // CONFIG
    const API_URL = 'direct_gateway.php';
    const DIRECT_URL = "direct_gateway.php"; 
    const SESSION = localStorage.getItem('vt_session');
    const USER_ID = localStorage.getItem('vt_userid');
    
    let userMap = {}; let allFields = []; let visibleColumns = []; let filters = {}; 
    let currentPage = 0; let itemsPerPage = 20; let isFetching = false;
    let missingIdsRequested = new Set(); let mobileSearchTimeout;

    // *** UPDATED: EXACT REQUESTED FIELDS ***
    const TARGET_DEFAULTS = [
        "First Name", "Last Name", 
        "Primary Phone", "Mobile Phone", 
        "Assigned To", "Project", 
        "Lead Channel", "Channel", "Lead Source", 
        "Last Comment", "Latest Log Type", "Latest Log Date", 
        "Created Time", "Modified Time", "Email"
    ];

    document.addEventListener('DOMContentLoaded', async () => {
        if(!SESSION) { window.location.href = '../../login.php'; return; }
        fetchUsersMap(); 
        await fetchDescribe();
        resolveDefaultColumns();
        rebuildGridHeaders();
        fetchLeads();
    });

    // FETCH ENGINE
    async function fetchLeads() {
        if(isFetching) return; isFetching=true;
        document.getElementById('loading-state').classList.remove('hidden');
        document.getElementById('leads-table-body').innerHTML=''; 
        document.getElementById('mobile-card-container').innerHTML='';
        document.getElementById('empty-state').classList.add('hidden');

        try {
            const directQuery = `${DIRECT_URL}?operation=fetch_leads&userid=${USER_ID}&scope=team&limit=${itemsPerPage}&offset=${currentPage*itemsPerPage}`;
            const res = await fetch(directQuery);
            const data = await res.json();

            if(data.success) {
                renderData(data.result);
            } else {
                console.warn("Direct DB Failed. Switching to API...", data);
                await fetchLeadsViaAPI();
            }
        } catch(e) {
            console.warn("Network Error. API fallback.", e);
            await fetchLeadsViaAPI();
        } finally {
            isFetching=false; 
            document.getElementById('loading-state').classList.add('hidden');
        }
    }

    async function fetchLeadsViaAPI() {
        // Fallback logic for API (standard fields only)
        try {
            const always = ['id','lead_no','mobile','phone','leadsource','createdtime','modifiedtime','assigned_user_id','firstname','lastname','leadstatus'];
            const select = [...new Set([...always, ...visibleColumns.map(c=>c.name)])].join(',');
            const q = `SELECT ${select} FROM Leads WHERE createdtime>='2024-01-01' ORDER BY modifiedtime DESC LIMIT ${currentPage*itemsPerPage}, ${itemsPerPage};`;
            const r = await fetch(`${API_URL}?operation=query&sessionName=${SESSION}&query=${encodeURIComponent(q)}`);
            const d = await r.json();
            if(d.success) renderData(d.result);
            else document.getElementById('empty-state').classList.remove('hidden');
        } catch(e) { console.error(e); }
    }

    function renderData(leads) {
        if(!leads || leads.length === 0) { document.getElementById('empty-state').classList.remove('hidden'); return; }
        renderDesk(leads);
        renderMobileCards(leads);
        updatePagination(leads.length);
        document.getElementById('record-count').innerText = `${leads.length} Loaded`;
        document.getElementById('mob-count').innerText = `${leads.length} LEADS`;
    }

    // *** UPDATED RENDERER ***
    function renderDesk(leads) {
        const tb = document.getElementById('leads-table-body');
        if(!leads.length) { document.getElementById('empty-state').classList.remove('hidden'); return; }
        
        leads.forEach(l => {
            const tr = document.createElement('tr');
            tr.className = "hover:bg-indigo-50/30 transition-colors group border-b border-gray-50";
            
            visibleColumns.forEach(c => {
                const td = document.createElement('td'); 
                td.className="p-4 whitespace-nowrap text-gray-600 text-xs"; // Compact text
                
                // MAPPING LABELS TO DATA KEYS
                let key = c.name;
                if(c.label === 'Last Comment') key = 'last_comment'; // Mapped to cf_1139 in backend
                if(c.label === 'Project') key = 'project'; // Mapped to cf_975
                if(c.label === 'Channel') key = 'channel'; // Mapped to cf_971
                if(c.label === 'Lead Channel') key = 'lead_channel'; // Mapped to cf_969
                if(c.label === 'Mobile Phone') key = 'mobile';
                if(c.label === 'Primary Phone') key = 'phone';
                if(c.label === 'Latest Log Type') key = 'last_log_type';
                if(c.label === 'Latest Log Date') key = 'last_log_date';

                let v = l[key] || l[c.name] || '';

                // FORMATTING
                if(c.name === 'lastname' || c.name === 'firstname') {
                    v = `<a href="view.php?id=${l.id}" class="font-bold text-navy-700 hover:text-indigo-600 hover:underline">${v}</a>`;
                }
                else if(c.label === 'Last Comment') {
                    if(v.length > 30) v = `<span title="${v}">${v.substring(0,30)}...</span>`;
                }
                else if(c.label === 'Latest Log Type') {
                     if(v === 'Call') v = `<span class="text-green-600 font-bold flex items-center gap-1"><i class="ph-bold ph-phone"></i> Call</span>`;
                     else if(v === 'Meeting') v = `<span class="text-orange-600 font-bold flex items-center gap-1"><i class="ph-bold ph-users"></i> Meet</span>`;
                }
                else if(c.name === 'assigned_user_id') {
                    // Gateway sends names directly now, so we just display. 
                    // If it sends ID (fallback), we map.
                    if(v.includes('x')) {
                        v = userMap[v] || v;
                        if(v.includes('x')) resolveMissingUser(v);
                    }
                    v = `<span class="font-bold text-navy-700">${v}</span>`;
                }
                
                td.innerHTML = v; 
                tr.appendChild(td);
            });
            
            const act = document.createElement('td'); 
            act.className = "p-4 text-right sticky right-0 bg-white group-hover:bg-indigo-50/30";
            act.innerHTML = `<div class="flex justify-end gap-2"><button onclick="location.href='view.php?id=${l.id}'" class="w-8 h-8 rounded-lg border border-gray-100 text-gray-400 hover:text-blue-600"><i class="ph-bold ph-eye"></i></button><button onclick="location.href='manage.php?id=${l.id}'" class="w-8 h-8 rounded-lg border border-gray-100 text-gray-400 hover:text-indigo-600"><i class="ph-bold ph-pencil-simple"></i></button></div>`;
            tr.appendChild(act); 
            tb.appendChild(tr);
        });
    }

    function renderMobileCards(leads) {
        const c = document.getElementById('mobile-card-container');
        if(!leads.length) return;
        leads.forEach(l => {
            const div = document.createElement('div');
            const color = getStatusColorCode(l.leadstatus);
            div.className = "bg-white p-4 rounded-2xl shadow-sm border border-gray-100 flex flex-col gap-3 relative overflow-hidden";
            div.style.borderLeft = `4px solid ${color}`;
            
            const uid = l.assigned_user_id;
            const uDisplay = uid.includes('x') ? (userMap[uid] || '...') : uid;
            const phone = l.phone || l.mobile || '-';
            
            div.innerHTML = `
                <div class="flex justify-between items-start cursor-pointer" onclick="location.href='view.php?id=${l.id}'">
                    <div>
                        <h4 class="text-base font-extrabold text-navy-700 hover:text-indigo-600">${l.firstname||''} ${l.lastname||''}</h4>
                        <p class="text-[10px] text-gray-400 font-mono mt-0.5">#${l.lead_no}</p>
                    </div>
                    <span class="px-2 py-0.5 rounded text-[10px] font-bold uppercase ${getStatusStyle(l.leadstatus)}">${l.leadstatus||'New'}</span>
                </div>
                <div class="grid grid-cols-2 gap-2 text-xs" onclick="location.href='view.php?id=${l.id}'">
                    <div class="bg-gray-50 p-2 rounded-lg flex items-center gap-2"><i class="ph-fill ph-phone text-indigo-500"></i> <span class="font-bold">${phone}</span></div>
                    <div class="bg-gray-50 p-2 rounded-lg flex items-center gap-2"><i class="ph-fill ph-tag text-purple-500"></i> <span class="truncate">${l.leadsource||'-'}</span></div>
                    <div class="bg-gray-50 p-2 rounded-lg flex items-center gap-2"><i class="ph-fill ph-user text-blue-500"></i> <span class="truncate">${uDisplay}</span></div>
                    <div class="bg-gray-50 p-2 rounded-lg flex items-center gap-2"><i class="ph-fill ph-clock text-orange-500"></i> <span>${(l.modifiedtime||'').split(' ')[0]}</span></div>
                </div>
                <div class="flex gap-2 mt-1">
                    <a href="tel:${phone}" class="flex-1 bg-green-50 text-green-700 py-2.5 rounded-xl text-xs font-bold flex items-center justify-center gap-2 border border-green-100 hover:bg-green-100"><i class="ph-bold ph-phone-call"></i> Call</a>
                    <button onclick="location.href='view.php?id=${l.id}'" class="flex-1 bg-gray-50 text-gray-600 py-2.5 rounded-xl text-xs font-bold flex items-center justify-center gap-2 hover:bg-gray-100 border border-gray-100"><i class="ph-bold ph-eye"></i> View</button>
                    <button onclick="location.href='manage.php?id=${l.id}'" class="flex-1 bg-navy-700 text-white py-2.5 rounded-xl text-xs font-bold flex items-center justify-center gap-2 shadow-lg shadow-navy-700/20"><i class="ph-bold ph-pencil-simple"></i> Edit</button>
                </div>`;
            c.appendChild(div);
        });
    }

    // UTILS
    async function fetchUsersMap() { if(localStorage.getItem('vt_umap_v7')) { userMap = JSON.parse(localStorage.getItem('vt_umap_v7')); updateNames(); return; } try { const [u, g] = await Promise.all([ fetch(`${API_URL}?operation=query&sessionName=${SESSION}&query=${encodeURIComponent("SELECT id,first_name,last_name,user_name FROM Users LIMIT 1000")}`), fetch(`${API_URL}?operation=query&sessionName=${SESSION}&query=${encodeURIComponent("SELECT id,groupname FROM Groups LIMIT 500")}`) ]); const ud = await u.json(); const gd = await g.json(); if(ud.success) ud.result.forEach(x => userMap[x.id] = ((x.first_name||x.last_name)?`${x.first_name} ${x.last_name}`:x.user_name).trim()); if(gd.success) gd.result.forEach(x => userMap[x.id] = x.groupname); localStorage.setItem('vt_umap_v7', JSON.stringify(userMap)); updateNames(); } catch(e){} }
    function updateNames() { document.querySelectorAll('[data-uid]').forEach(el => { const id = el.getAttribute('data-uid'); if(userMap[id]) el.innerHTML = `<i class="ph-bold ph-user-circle text-gray-400"></i> ${userMap[id]}`; }); }
    async function resolveMissingUser(id) { if(!id || userMap[id] || missingIdsRequested.has(id)) return; missingIdsRequested.add(id); try { const r = await fetch(`${API_URL}?operation=retrieve&sessionName=${SESSION}&id=${id}`); const d = await r.json(); if(d.success) { const res = d.result; let name = res.groupname || ((res.first_name||res.last_name)?`${res.first_name} ${res.last_name}`:res.user_name).trim(); userMap[id] = name; updateNames(); } } catch(e){} }
    async function fetchDescribe() { if(localStorage.getItem('vt_flds')) { allFields = JSON.parse(localStorage.getItem('vt_flds')); return; } const r = await fetch(`${API_URL}?operation=describe&sessionName=${SESSION}&elementType=Leads`); const d = await r.json(); if(d.success) { allFields = d.result.fields; localStorage.setItem('vt_flds', JSON.stringify(allFields)); } }
    
    // IMPORTANT: Inject our manual columns if describe() doesn't find them
    function resolveDefaultColumns() { 
        visibleColumns = [];
        TARGET_DEFAULTS.forEach(t => { 
            const f = allFields.find(x => x.label.toLowerCase() === t.toLowerCase()); 
            if(f) {
                visibleColumns.push({name:f.name, label:f.label});
            } else {
                // If not in API Describe (Manual field), add it anyway
                visibleColumns.push({name: t.toLowerCase().replace(/ /g,'_'), label: t});
            }
        }); 
        renderColumnManager(); 
    }
    
    function toggleColumnMenu(e) { e.stopPropagation(); document.getElementById('column-manager-menu').classList.toggle('hidden'); }
    function renderColumnManager() { const l=document.getElementById('column-list'); l.innerHTML=''; allFields.forEach(f=>{ if(f.name==='id')return; const chk=visibleColumns.some(c=>c.name===f.name)?'checked':''; const d=document.createElement('div'); d.className="flex items-center gap-2 p-1 hover:bg-gray-50 rounded cursor-pointer"; d.innerHTML=`<input type="checkbox" ${chk} class="text-indigo-600 rounded focus:ring-indigo-500"><span class="text-xs text-gray-700">${f.label}</span>`; d.onclick=(e)=>{ if(e.target.tagName!=='INPUT') d.querySelector('input').click(); toggleColumn(f.name,f.label); }; l.appendChild(d); }); }
    function toggleColumn(n,l) { if(visibleColumns.find(c=>c.name===n)) visibleColumns=visibleColumns.filter(c=>c.name!==n); else visibleColumns.push({name:n,label:l}); localStorage.setItem('horizon_leads_cols_v3',JSON.stringify(visibleColumns)); rebuildGridHeaders(); fetchLeads(); }
    function rebuildGridHeaders() { const r=document.getElementById('table-header-row'); r.innerHTML=''; visibleColumns.forEach(c=>{ const th=document.createElement('th'); th.className="p-4 border-b border-gray-200 min-w-[150px] group hover:bg-gray-100 transition-colors cursor-default relative"; th.innerHTML=`<div class="flex justify-between items-center"><span>${c.label}</span><button onclick="openFilterPopup(event,'${c.name}')" class="filter-trigger ${filters[c.name]?'text-indigo-600 bg-indigo-50':'text-gray-300'} w-6 h-6 rounded flex items-center justify-center hover:bg-white"><i class="ph-bold ph-funnel"></i></button></div>`; r.appendChild(th); }); r.insertAdjacentHTML('beforeend','<th class="p-4 border-b border-gray-200 text-right">Action</th>'); }
    function openFilterPopup(e,n) { e.stopPropagation(); activeFilterField=n; document.getElementById('filter-popover').classList.remove('hidden'); const r=e.currentTarget.getBoundingClientRect(); const p=document.getElementById('filter-popover'); p.style.top=(r.bottom+window.scrollY+5)+'px'; p.style.left=(r.left+window.scrollX-200)+'px'; }
    function closeFilterPopup() { document.getElementById('filter-popover').classList.add('hidden'); }
    function applyFilter() { const v=document.getElementById('filter-value').value; if(v) filters[activeFilterField]={op:document.getElementById('filter-operator').value,val:v}; else delete filters[activeFilterField]; closeFilterPopup(); rebuildGridHeaders(); currentPage=0; fetchLeads(); }
    function clearCurrentFilter() { delete filters[activeFilterField]; closeFilterPopup(); rebuildGridHeaders(); fetchLeads(); }
    function resetFilters() { filters={}; rebuildGridHeaders(); fetchLeads(); }
    function restoreDefaults() { localStorage.removeItem('horizon_leads_cols_v3'); location.reload(); }
    function changePageSize() { itemsPerPage=parseInt(document.getElementById('pageSize').value); currentPage=0; fetchLeads(); }
    function changePage(d) { currentPage+=d; document.getElementById('page-info').innerText=`Page ${currentPage+1}`; fetchLeads(); }
    function updatePagination(c) { 
        const btnPrev = document.getElementById('p-prev');
        const btnNext = document.getElementById('p-next');
        if(btnPrev) btnPrev.disabled = (currentPage === 0);
        if(btnNext) btnNext.disabled = (c < itemsPerPage); 
    }
    function getStatusStyle(s) { s=(s||'').toLowerCase(); if(s.includes('hot'))return 'bg-red-50 text-red-600 border-red-100'; if(s.includes('qualified'))return 'bg-green-50 text-green-600 border-green-100'; if(s.includes('cold'))return 'bg-blue-50 text-blue-600 border-blue-100'; return 'bg-gray-50 text-gray-500 border-gray-200'; }
    function getStatusColorCode(s) { s=(s||'').toLowerCase(); if(s.includes('hot'))return '#EF4444'; if(s.includes('qualified'))return '#10B981'; return '#6366F1'; }
    function handleMobileSearch() { clearTimeout(mobileSearchTimeout); mobileSearchTimeout=setTimeout(()=>{ const p=document.getElementById('mobPhone').value.trim(); const s=document.getElementById('mobSource').value.trim(); if(p) filters['phone']={op:'contains',val:p}; else delete filters['phone']; if(s) filters['leadsource']={op:'contains',val:s}; else delete filters['leadsource']; currentPage=0; fetchLeads(); },800); }
</script>

<style>
    @keyframes fadeInDown { from { opacity: 0; transform: translateY(-5px); } to { opacity: 1; transform: translateY(0); } }
    .animate-fade-in-down { animation: fadeInDown 0.15s ease-out forwards; }
    .hide-scrollbar::-webkit-scrollbar { display: none; }
    .hide-scrollbar { -ms-overflow-style: none; scrollbar-width: none; }
</style>