<?php
// modules/leads/direct_gateway.php
// 1. LIST: Uses the simple, raw SQL from your "Working Code" to fix "No leads found".
// 2. HISTORY: Direct SQL fetch.

header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json; charset=utf-8');

// Enable error reporting for debugging if SQL fails
ini_set('display_errors', 0);
error_reporting(E_ALL);

while (ob_get_level()) ob_end_clean();
ob_start();

$db_host = '92.205.180.58'; 
$db_name = 'helfaya'; 
$db_user = 'helfaya';       
$db_pass = 'Hel@2010';  
$crm_url = 'https://peopleandplaceseg.com/crm/webservice.php';

$op = $_REQUEST['operation'] ?? '';

// ROUTER
if ($op === 'get_picklists') { fetchPicklistsDirect($db_host, $db_user, $db_pass, $db_name); exit; }
if ($op === 'retrieve') { fetchSingleLeadDirect($db_host, $db_user, $db_pass, $db_name); exit; }
if ($op === 'fetch_leads') { fetchLeadsMain($db_host, $db_user, $db_pass, $db_name); exit; }
if ($op === 'fetch_history') { fetchHistoryDirect($db_host, $db_user, $db_pass, $db_name); exit; }

// WRITE PROXY
if ($op === 'create' || $op === 'update' || $op === 'query') { handleProxy($crm_url); exit; }

echo json_encode(['success'=>false, 'error'=>'Invalid Operation']);
exit;

// ====================================================
// 1. LIST VIEW (Restored "Working Code" SQL)
// ====================================================
function fetchLeadsMain($host, $user, $pass, $db_name) {
    $mysqli = new mysqli($host, $user, $pass, $db_name);
    if ($mysqli->connect_error) { echo json_encode(['success'=>false, 'error'=>'DB Connection Error']); exit; }
    $mysqli->set_charset("utf8mb4");

    $userId = (int)($_REQUEST['userid'] ?? 0);
    $limit = (int)($_REQUEST['limit'] ?? 50);
    $offset = (int)($_REQUEST['offset'] ?? 0);

    if (!$userId) { echo json_encode(['success'=>false, 'message'=>'No User ID']); exit; }

    $ownerFilter = ""; 
    $adminCheck = $mysqli->query("SELECT is_admin FROM vtiger_users WHERE id = $userId");
    $isAdmin = ($adminCheck && $adminCheck->fetch_assoc()['is_admin'] === 'on');

    if (!$isAdmin) {
        $allowedIds = array_merge([$userId], getAllSubordinates($mysqli, $userId));
        $idList = implode(',', array_unique($allowedIds));
        $ownerFilter = "AND e.smownerid IN ($idList)";
    }

    // RAW SQL FROM YOUR WORKING VERSION
    // We select standard columns. PHP will handle the differentiation.
    $sql = "SELECT 
            l.leadid, l.lead_no, l.firstname, l.lastname, l.email, l.leadsource, l.leadstatus,
            COALESCE(a.phone, '') as phone, 
            COALESCE(a.mobile, '') as mobile,
            cf.cf_975 as project, cf.cf_969 as lead_channel, cf.cf_971 as channel, 
            cf.cf_1139 as last_comment, cf.cf_2992 as system_status,
            e.smownerid, e.createdtime, e.modifiedtime,
            u.first_name, u.last_name, g.groupname
            FROM vtiger_leaddetails l
            INNER JOIN vtiger_crmentity e ON l.leadid = e.crmid
            LEFT JOIN vtiger_leadaddress a ON l.leadid = a.leadaddressid
            LEFT JOIN vtiger_leadscf cf ON l.leadid = cf.leadid 
            LEFT JOIN vtiger_users u ON e.smownerid = u.id
            LEFT JOIN vtiger_groups g ON e.smownerid = g.groupid
            WHERE e.deleted = 0 AND l.converted = 0 $ownerFilter 
            ORDER BY e.modifiedtime DESC LIMIT $offset, $limit";

    $result = $mysqli->query($sql);
    
    // DEBUG: Output SQL error if query fails
    if (!$result) {
        echo json_encode(['success'=>false, 'error'=>'SQL Error: ' . $mysqli->error]);
        exit;
    }

    $leads = []; 
    $leadIds = [];

    while ($row = $result->fetch_assoc()) {
        $row['id'] = '10x' . $row['leadid'];
        
        // --- OWNER LOGIC (STRICT) ---
        // Vtiger User Table usually uses 'first_name' / 'last_name' (with underscore)
        // Lead Table uses 'firstname' / 'lastname' (no underscore)
        
        if (!empty($row['groupname'])) { 
            $row['assigned_user_id'] = $row['groupname']; 
        } 
        // Check strict keys for User to prevent mixing with Lead
        elseif (isset($row['first_name']) && isset($row['last_name'])) { 
            $row['assigned_user_id'] = trim($row['first_name'] . ' ' . $row['last_name']); 
        } 
        else { 
            $row['assigned_user_id'] = 'Unknown'; 
        }
        
        // Remove User columns from output so they don't overwrite Lead columns in JS
        unset($row['first_name'], $row['last_name'], $row['groupname']);
        
        $row['last_log_type'] = ''; 
        $row['last_log_date'] = '';
        $leads[$row['id']] = $row;
        $leadIds[] = $row['leadid'];
    }

    // Activity Loop
    if (!empty($leadIds)) {
        $idStr = implode(',', $leadIds);
        $actSql = "SELECT parent_id, activitytype, date_start FROM vtiger_activity WHERE parent_id IN ($idStr) ORDER BY date_start ASC"; 
        $actRes = $mysqli->query($actSql);
        if($actRes) while($a = $actRes->fetch_assoc()) {
            $lid = '10x'.$a['parent_id'];
            if(isset($leads[$lid])) { 
                $leads[$lid]['last_log_type'] = $a['activitytype']; 
                $leads[$lid]['last_log_date'] = $a['date_start']; 
            }
        }
    }

    echo json_encode(['success' => true, 'result' => array_values($leads)]);
    $mysqli->close();
}

// ====================================================
// 2. FETCH HISTORY (DIRECT SQL)
// ====================================================
function fetchHistoryDirect($host, $user, $pass, $db_name) {
    $mysqli = new mysqli($host, $user, $pass, $db_name);
    if ($mysqli->connect_error) { echo json_encode(['success'=>false, 'error'=>'DB Fail']); exit; }
    $mysqli->set_charset("utf8mb4");

    $idRaw = $_REQUEST['id'] ?? '';
    $parts = explode('x', $idRaw);
    $leadId = (int)end($parts);

    if (!$leadId) { echo json_encode(['success'=>false, 'error'=>'Invalid ID']); exit; }

    $feed = [];

    // COMMENTS
    $sqlComm = "SELECT m.commentcontent, m.createdtime, u.first_name, u.last_name, u.user_name
                FROM vtiger_modcomments m
                INNER JOIN vtiger_crmentity e ON m.modcommentsid = e.crmid
                LEFT JOIN vtiger_users u ON e.smownerid = u.id
                WHERE m.related_to = $leadId AND e.deleted = 0 
                ORDER BY m.createdtime DESC LIMIT 50";
    
    $resComm = $mysqli->query($sqlComm);
    if($resComm) while($row = $resComm->fetch_assoc()) {
        $owner = trim($row['first_name'] . ' ' . $row['last_name']);
        if(empty($owner)) $owner = $row['user_name'] ? $row['user_name'] : 'User';
        $feed[] = ['type'=>'note', 'content'=>$row['commentcontent'], 'date'=>$row['createdtime'], 'owner'=>$owner, 'status'=>''];
    }

    // ACTIVITIES
    $sqlAct = "SELECT a.subject, a.activitytype, a.date_start, a.time_start, a.eventstatus, e.description,
               u.first_name, u.last_name, u.user_name
               FROM vtiger_activity a
               INNER JOIN vtiger_seactivityrel rel ON a.activityid = rel.activityid
               INNER JOIN vtiger_crmentity e ON a.activityid = e.crmid
               LEFT JOIN vtiger_users u ON e.smownerid = u.id
               WHERE rel.crmid = $leadId AND e.deleted = 0
               ORDER BY a.date_start DESC LIMIT 50";

    $resAct = $mysqli->query($sqlAct);
    if($resAct) while($row = $resAct->fetch_assoc()) {
        $owner = trim($row['first_name'] . ' ' . $row['last_name']);
        if(empty($owner)) $owner = $row['user_name'] ? $row['user_name'] : 'User';
        
        $feed[] = [
            'type' => 'event',
            'subtype' => $row['activitytype'],
            'content' => $row['subject'],
            'desc' => $row['description'],
            'date' => $row['date_start'] . ' ' . $row['time_start'],
            'owner' => $owner,
            'status' => $row['eventstatus']
        ];
    }

    usort($feed, function($a, $b) { return strtotime($b['date']) - strtotime($a['date']); });
    echo json_encode(['success' => true, 'result' => $feed]);
    $mysqli->close();
}

// ====================================================
// 3. SINGLE VIEW
// ====================================================
function fetchSingleLeadDirect($host, $user, $pass, $db_name) {
    $mysqli = new mysqli($host, $user, $pass, $db_name);
    if ($mysqli->connect_error) { echo json_encode(['success'=>false]); exit; }
    $mysqli->set_charset("utf8mb4");

    $idRaw = $_REQUEST['id'] ?? '';
    $parts = explode('x', $idRaw);
    $leadId = (int)end($parts); 

    if (!$leadId) { echo json_encode(['success'=>false, 'error'=>'Invalid ID']); exit; }

    $sql = "SELECT 
            l.leadid, l.lead_no, l.firstname, l.lastname, l.email, l.leadsource, l.leadstatus, e.description,
            a.phone, a.mobile, a.city, a.country, 
            cf.cf_975, cf.cf_979, cf.cf_981, cf.cf_971, cf.cf_969, cf.cf_2992,
            cf.cf_973, cf.cf_2050, cf.cf_2998, cf.cf_1104, cf.cf_965,
            e.smownerid, e.createdtime, e.modifiedtime,
            u.first_name, u.last_name, g.groupname
            FROM vtiger_leaddetails l
            INNER JOIN vtiger_crmentity e ON l.leadid = e.crmid
            LEFT JOIN vtiger_leadaddress a ON l.leadid = a.leadaddressid
            LEFT JOIN vtiger_leadscf cf ON l.leadid = cf.leadid
            LEFT JOIN vtiger_users u ON e.smownerid = u.id
            LEFT JOIN vtiger_groups g ON e.smownerid = g.groupid
            WHERE l.leadid = $leadId AND e.deleted = 0";

    $res = $mysqli->query($sql);
    if ($res && $res->num_rows > 0) {
        $row = $res->fetch_assoc();
        $out = $row;
        $out['id'] = "10x" . $row['leadid'];
        
        if (!empty($row['groupname'])) { $out['assigned_user_id'] = $row['groupname']; } 
        elseif(isset($row['first_name'])) { $out['assigned_user_id'] = trim($row['first_name'] . ' ' . $row['last_name']); }
        else { $out['assigned_user_id'] = 'Unknown'; }
        
        // Remove collision fields
        unset($out['first_name'], $out['last_name'], $out['groupname']);

        foreach($out as $k => $v) { if($v === null) $out[$k] = ''; }
        echo json_encode(['success' => true, 'result' => $out]);
    } else { echo json_encode(['success' => false, 'error' => 'Lead not found']); }
    $mysqli->close();
}

// ====================================================
// 4. PICKLISTS & PROXY
// ====================================================
function fetchPicklistsDirect($host, $user, $pass, $db_name) {
    $mysqli = new mysqli($host, $user, $pass, $db_name);
    if ($mysqli->connect_error) { echo json_encode(['success'=>false]); exit; }
    $mysqli->set_charset("utf8mb4");

    $targetFields = ['leadstatus', 'leadsource', 'industry', 'cf_2992', 'cf_975', 'cf_979', 'cf_981', 'cf_971', 'cf_969'];
    $data = [];

    foreach ($targetFields as $field) {
        $res = $mysqli->query("SELECT $field FROM vtiger_$field WHERE $field NOT LIKE '%Broker%' AND $field NOT LIKE '%Option%'");
        if ($res) while ($row = $res->fetch_array()) {
            $val = trim($row[0]);
            if ($val !== 'Ambassdor_HIDDEN') $data[$field][] = ['label' => $val, 'value' => $val];
        }
    }

    $deps = []; $patchRules = [];
    $dRes = $mysqli->query("SELECT id, sourcefield, targetfield, sourcevalue, targetvalues FROM vtiger_picklist_dependency");
    if ($dRes) while ($row = $dRes->fetch_assoc()) {
        $src = $row['sourcefield']; $trg = $row['targetfield']; $srcVal = trim(html_entity_decode($row['sourcevalue']));
        preg_match_all('/"((?:[^"\\\\]|\\\\.)*)"/', html_entity_decode($row['targetvalues']), $matches);
        $targets = [];
        if (!empty($matches[1])) {
            foreach ($matches[1] as $v) {
                $dec = json_decode('"' . $v . '"');
                $val = !is_null($dec) ? $dec : $v;
                if (stripos($val, 'Broker')===false && stripos($val, 'Option')===false && $val !== 'Ambassdor_HIDDEN') $targets[] = $val;
            }
        }
        if (!empty($targets)) {
            if ($row['id'] == 259 || $srcVal === 'Ambassdor_HIDDEN') $patchRules[$src][$trg] = $targets;
            else $deps[$src][$trg][$srcVal] = $targets;
        }
    }
    foreach ($patchRules as $src => $trgs) foreach ($trgs as $trg => $vals) {
        $deps[$src][$trg]['Ambassdor'] = $vals;
        $deps[$src][$trg]['Ambassador'] = $vals;
    }
    echo json_encode(['success' => true, 'picklists' => $data, 'dependencies' => $deps]);
    $mysqli->close();
}

function handleProxy($url) {
    if (ob_get_length()) ob_clean();
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url); 
    curl_setopt($ch, CURLOPT_POST, true); 
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($_REQUEST));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);  
    $resp = curl_exec($ch);
    echo $resp;
    exit;
}

function getAllSubordinates($db, $managerId) {
    $subs = [];
    $res = $db->query("SELECT id FROM vtiger_users WHERE reports_to_id = $managerId AND status='Active'");
    if ($res) while ($row = $res->fetch_assoc()) { $subs[] = $row['id']; $subs = array_merge($subs, getAllSubordinates($db, $row['id'])); }
    return $subs;
}
?>