<?php
// modules/leads/debug_deep.php
// PURPOSE: Find the specific row/column causing the crash
header('Content-Type: text/plain; charset=utf-8');

// 1. DATABASE
$db_host = '92.205.180.58'; 
$db_name = 'helfaya'; 
$db_user = 'helfaya';       
$db_pass = 'Hel@2010';  

$mysqli = @new mysqli($db_host, $db_user, $db_pass, $db_name);
if ($mysqli->connect_error) die("CRITICAL: DB Connection Failed.\n");
$mysqli->set_charset("utf8"); // Try standard UTF8 first

echo "--- STARTING DIAGNOSTIC ---\n";

// 2. FETCH 10 LEADS (To test data quality)
// We include the specific columns that might cause issues (Comments, Projects)
$sql = "SELECT 
        l.leadid, l.lastname, l.firstname,
        cf.cf_1139 as last_comment, 
        cf.cf_975 as project
        FROM vtiger_leaddetails l
        INNER JOIN vtiger_crmentity e ON l.leadid = e.crmid
        LEFT JOIN vtiger_leadscf cf ON l.leadid = cf.leadid
        WHERE e.deleted = 0 
        LIMIT 5";

$result = $mysqli->query($sql);

if (!$result) {
    die("CRITICAL SQL ERROR: " . $mysqli->error . "\n");
}

echo "SQL Query: Success.\n";
echo "Rows Found: " . $result->num_rows . "\n\n";

// 3. ROW-BY-ROW JSON TEST
$i = 1;
while ($row = $result->fetch_assoc()) {
    echo "Checking Row #$i (ID: " . $row['leadid'] . ")...\n";
    
    // Test JSON Encoding for this specific row
    $json = json_encode($row);
    
    if ($json === false) {
        echo "❌ FAILURE IN ROW #$i\n";
        echo "   Error: " . json_last_error_msg() . "\n";
        echo "   Problematic Data:\n";
        
        // Check which column is bad
        foreach ($row as $key => $val) {
            if (json_encode([$key => $val]) === false) {
                echo "   -> COLUMN '$key' has bad data.\n";
                echo "      Value Hex: " . bin2hex($val) . "\n"; // Print HEX to identify encoding
            }
        }
        die("\nDIAGNOSIS: The system crashes because of the column above. We need to fix the encoding for this column.\n");
    } else {
        echo "✅ Row #$i is OK.\n";
    }
    $i++;
}

echo "\n--- DIAGNOSTIC COMPLETE: ALL CLEAR ---\n";
echo "If you see this, the Basic SQL is fine. The issue might be in the Real-Time Activity logic.\n";
?>