<?php require_once '../../includes/header.php'; ?>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@18.1.1/build/css/intlTelInput.css">

<style>
    /* View Layout */
    .view-card { background: white; border-radius: 1rem; padding: 1.5rem; border: 1px solid #E5E7EB; margin-bottom: 1.5rem; box-shadow: 0 1px 3px rgba(0,0,0,0.05); }
    .input-label { display: block; font-size: 0.75rem; font-weight: 700; color: #6B7280; margin-bottom: 0.25rem; text-transform: uppercase; }
    .std-input { width: 100%; border: 1px solid #E5E7EB; border-radius: 0.5rem; padding: 0.5rem 0.75rem; font-size: 0.875rem; outline: none; font-weight: 600; color: #1F2937; }
    .std-input:focus { border-color: #10B981; }
    .select2-container .select2-selection--single { height: 38px !important; border-radius: 0.5rem !important; border: 1px solid #E5E7EB !important; }
    .select2-container--default .select2-selection--single .select2-selection__arrow { top: 6px !important; }
    .iti { width: 100%; }
</style>

<div class="max-w-7xl mx-auto pb-32 px-4 md:px-6 pt-6">
    <div class="flex justify-between items-center mb-8">
        <div><h1 class="text-3xl font-extrabold text-navy-700">New Lead</h1></div>
        <div class="flex gap-3">
             <button onclick="history.back()" class="bg-white border border-gray-200 text-gray-600 px-5 py-2.5 rounded-xl text-xs font-bold">Cancel</button>
             <button onclick="saveNewLead()" id="btn-save" class="bg-green-600 text-white px-6 py-2.5 rounded-xl text-xs font-bold hover:shadow-lg flex items-center gap-2"><i class="ph-bold ph-plus"></i> Create</button>
        </div>
    </div>

    <form id="create-form">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <div class="lg:col-span-1 view-card space-y-4">
                <h3 class="text-xs font-bold text-gray-400 uppercase mb-4">Contact Info</h3>
                <div><label class="input-label">Mobile</label><input type="tel" id="input-mobile-flag" class="std-input"><input type="hidden" name="mobile" id="input-mobile"></div>
                <div><label class="input-label">Primary Phone <span class="text-red-500">*</span></label><input type="tel" id="input-phone-flag" class="std-input"><input type="hidden" name="phone" id="input-phone"></div>
                <div><label class="input-label">Email</label><input type="email" name="email" class="std-input"></div>
                <div class="grid grid-cols-2 gap-2">
                    <div><label class="input-label">City</label><input type="text" name="city" class="std-input"></div>
                    <div><label class="input-label">Country</label><input type="text" name="country" class="std-input"></div>
                </div>
            </div>

            <div class="lg:col-span-1 view-card space-y-4">
                <h3 class="text-xs font-bold text-gray-400 uppercase mb-4">Identity</h3>
                <div><label class="input-label">First Name *</label><input type="text" name="firstname" id="input-firstname" class="std-input"></div>
                <div><label class="input-label">Last Name *</label><input type="text" name="lastname" id="input-lastname" class="std-input"></div>
                <div><label class="input-label">National ID</label><input type="text" name="cf_1104" class="std-input"></div>
                <div><label class="input-label">Passport</label><input type="text" name="cf_965" class="std-input"></div>
                <div class="mt-4 pt-4 border-t border-gray-100">
                    <label class="input-label">Lead Status *</label><select name="leadstatus" id="input-leadstatus" class="select2-enable w-full"></select>
                </div>
            </div>

            <div class="lg:col-span-1 view-card space-y-4">
                <h3 class="text-xs font-bold text-gray-400 uppercase mb-4">Details</h3>
                <div><label class="input-label">Project</label><select name="cf_975" id="input-cf_975" class="select2-enable w-full" onchange="triggerDependency('cf_975')"></select></div>
                <div class="grid grid-cols-2 gap-2">
                    <div><label class="input-label">Unit Type</label><select name="cf_979" id="input-cf_979" class="select2-enable w-full"></select></div>
                    <div><label class="input-label">Specs</label><select name="cf_981" id="input-cf_981" class="select2-enable w-full"></select></div>
                </div>
                <div><label class="input-label">Channel (L1)</label><select name="cf_971" id="input-cf_971" class="select2-enable w-full" onchange="triggerDependency('cf_971')"></select></div>
                <div><label class="input-label">Lead Channel (L2)</label><select name="cf_969" id="input-cf_969" class="select2-enable w-full" onchange="triggerDependency('cf_969')"></select></div>
                <div><label class="input-label">Source (L3)</label><select name="leadsource" id="input-leadsource" class="select2-enable w-full"></select></div>
                <div class="mt-4"><label class="input-label">Notes</label><textarea name="description" rows="3" class="std-input h-auto"></textarea></div>
            </div>
        </div>
    </form>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@18.1.1/build/js/intlTelInput.min.js"></script>

<script>
    const READ_URL = 'direct_gateway.php';
    const WRITE_URL = 'save_lead.php'; 
    const SESSION = localStorage.getItem('vt_session');
    const USER_ID = localStorage.getItem('vt_userid'); // Likely "1"
    
    const PICKLISTS = ['leadstatus', 'cf_975', 'cf_979', 'cf_981', 'leadsource', 'cf_971', 'cf_969'];
    let DEPENDENCY_MAP = {}; let itiMobile, itiPhone;

    document.addEventListener('DOMContentLoaded', async () => {
        const opts = { utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@18.1.1/build/js/utils.js", initialCountry: "eg", preferredCountries: ["eg", "sa", "ae"], separateDialCode: true };
        itiMobile = window.intlTelInput(document.querySelector("#input-mobile-flag"), opts);
        itiPhone = window.intlTelInput(document.querySelector("#input-phone-flag"), opts);

        await loadMetadata();
        setTimeout(() => { $('#input-leadstatus').val("New").trigger('change'); triggerDependency('cf_975'); triggerDependency('cf_971'); }, 500);
    });

    async function loadMetadata() {
        try {
            const res = await fetch(`${READ_URL}?operation=get_picklists`);
            const data = await res.json();
            if(data.success) {
                const lists = data.picklists;
                DEPENDENCY_MAP = data.dependencies;
                PICKLISTS.forEach(key => {
                    const el = document.getElementById(`input-${key}`);
                    if(el && lists[key]) {
                        el.dataset.allOptions = JSON.stringify(lists[key]);
                        let html = `<option value="">Select...</option>`;
                        lists[key].forEach(opt => html += `<option value="${opt.value}">${opt.label}</option>`);
                        el.innerHTML = html;
                    }
                });
                $('.select2-enable').select2({ width: '100%' });
            }
        } catch(e) {}
    }

    function triggerDependency(sourceField) {
        const sourceVal = $(`#input-${sourceField}`).val(); 
        if (!DEPENDENCY_MAP[sourceField]) return;
        Object.keys(DEPENDENCY_MAP[sourceField]).forEach(targetField => {
            const targetSelect = document.getElementById(`input-${targetField}`);
            const allOptions = JSON.parse(targetSelect.dataset.allOptions || '[]');
            const allowedValues = DEPENDENCY_MAP[sourceField][targetField][sourceVal];
            let html = `<option value="">Select...</option>`;
            if (allowedValues && allowedValues.length > 0) {
                allOptions.forEach(opt => { if (allowedValues.includes(opt.value)) html += `<option value="${opt.value}">${opt.label}</option>`; });
            } else if (!sourceVal) {
                allOptions.forEach(opt => html += `<option value="${opt.value}">${opt.label}</option>`);
            }
            targetSelect.innerHTML = html;
            $(`#input-${targetField}`).val(null).trigger('change.select2'); 
            if(DEPENDENCY_MAP[targetField]) triggerDependency(targetField); 
        });
    }

    async function saveNewLead() {
        if(!$('#input-firstname').val() || !$('#input-lastname').val() || !$('#input-leadstatus').val()) { alert("Missing Name/Status"); return; }
        if(!itiPhone.isValidNumber()) { alert("Primary Phone Invalid"); return; }

        const btn = document.getElementById('btn-save'); btn.disabled = true; btn.innerHTML = "Creating...";

        const formData = new FormData(document.getElementById('create-form'));
        let values = {};
        formData.forEach((value, key) => values[key] = value);
        PICKLISTS.forEach(k => values[k] = $(`#input-${k}`).val());
        values.mobile = itiMobile.getNumber(); 
        values.phone = itiPhone.getNumber(); 
        
        // FIXED: Force format "19xID" if missing
        let uid = USER_ID;
        if (!uid.includes('x')) uid = '19x' + uid; 
        values.assigned_user_id = uid;

        try {
            const res = await fetch(WRITE_URL, {
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: new URLSearchParams({
                    operation: 'create',
                    sessionName: SESSION,
                    element: JSON.stringify(values)
                })
            });
            
            const data = await res.json();
            if(data.success) window.location.href = `view.php?id=${data.result.id}`;
            else { alert("Error: " + (data.error || data.raw)); btn.disabled = false; btn.innerHTML = "Create"; }
        } catch(e) { 
            console.error(e);
            alert("Server Error. Check console."); 
            btn.disabled = false; 
            btn.innerHTML = "Create";
        }
    }
</script>