<?php
require_once 'config/app.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?php echo APP_NAME; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@400;500;700&display=swap" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['DM Sans', 'sans-serif'] },
                    colors: { horizon: { 500: '#4318FF', 600: '#3311CC' } }
                }
            }
        }
    </script>
</head>
<body class="h-screen w-full flex bg-white overflow-hidden">

    <div class="w-full lg:w-1/2 flex items-center justify-center p-8 bg-white z-10">
        <div class="w-full max-w-md flex flex-col">
            <div class="mb-10">
                <h1 class="text-4xl font-bold text-gray-800 mb-2">Sign In</h1>
                <p class="text-gray-400 text-sm">Welcome to <?php echo APP_NAME; ?>. Please enter your details.</p>
            </div>

            <form id="loginForm" class="flex flex-col gap-6" onsubmit="performLogin(event)">
                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2 ml-1">Username</label>
                    <input type="text" id="username" class="w-full px-6 py-4 rounded-2xl border border-gray-200 text-gray-700 focus:outline-none focus:border-horizon-500 focus:ring-1 focus:ring-horizon-500 transition-all" required>
                </div>

                <div>
                    <label class="block text-sm font-bold text-gray-700 mb-2 ml-1">Password</label>
                    <input type="password" id="password" class="w-full px-6 py-4 rounded-2xl border border-gray-200 text-gray-700 focus:outline-none focus:border-horizon-500 focus:ring-1 focus:ring-horizon-500 transition-all" required>
                </div>

                <button type="submit" id="submitBtn" class="w-full bg-horizon-500 hover:bg-horizon-600 text-white font-bold py-4 rounded-2xl shadow-lg shadow-indigo-200 transition-all">
                    Sign In
                </button>
                
                <div id="errorMsg" class="hidden p-4 bg-red-50 text-red-500 text-sm rounded-xl text-center"></div>
            </form>
        </div>
    </div>

    <div class="hidden lg:flex w-1/2 bg-gradient-to-bl from-horizon-500 to-blue-600 relative items-center justify-center rounded-bl-[100px]">
        <div class="relative z-10 text-white text-center p-12">
            <h2 class="text-4xl font-bold mb-6">People & Places</h2>
            <p class="text-blue-100 text-lg">Sales Performance Dashboard</p>
        </div>
    </div>

    <script>
        // Pull config from PHP to JS
        const BRIDGE_URL = "<?php echo CRM_BRIDGE; ?>";

        async function performLogin(e) {
            e.preventDefault();
            const btn = document.getElementById('submitBtn');
            const errorDiv = document.getElementById('errorMsg');
            
            btn.innerHTML = "Authenticating...";
            btn.classList.add('opacity-70');
            errorDiv.classList.add('hidden');

            const payload = {
                username: document.getElementById('username').value,
                password: document.getElementById('password').value
            };

            try {
                const response = await fetch(BRIDGE_URL, {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify(payload)
                });

                const data = await response.json();

                if (data.success) {
                    // STORE SESSION
                    localStorage.setItem('vt_session', data.sessionName);
                    localStorage.setItem('vt_userid', data.userId);
                    localStorage.setItem('vt_user_info', JSON.stringify(data.userInfo));

                    // REDIRECT TO MODULES
                    window.location.href = 'modules/dashboard/home.php';
                } else {
                    throw new Error(data.message || "Login Failed");
                }

            } catch (err) {
                console.error(err);
                errorDiv.innerHTML = "Connection Error: " + err.message;
                errorDiv.classList.remove('hidden');
                btn.innerHTML = "Sign In";
                btn.classList.remove('opacity-70');
            }
        }
    </script>
</body>
</html>