<?php 
// horizon-app/index.php
require_once 'includes/header.php'; 
?>

<div class="max-w-5xl mx-auto h-[calc(100vh-100px)] flex flex-col justify-center items-center p-6">

    <div class="w-full max-w-2xl text-center space-y-6 mb-12">
        <div class="mb-4">
            <h1 class="text-4xl font-extrabold text-navy-700 tracking-tight mb-2">
                Welcome, <span id="idx-user" class="text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-indigo-600">User</span>
            </h1>
            <p class="text-gray-400 text-sm">Access your CRM workspace</p>
        </div>

        <div class="relative group z-20">
            <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                <i class="ph-bold ph-magnifying-glass text-indigo-400 text-xl"></i>
            </div>
            <input type="text" id="globalSearch" onkeyup="performGlobalSearch()" 
                class="block w-full pl-12 pr-4 py-4 bg-white border-0 ring-1 ring-gray-100 rounded-2xl text-gray-700 placeholder-gray-400 focus:ring-2 focus:ring-indigo-500 shadow-xl shadow-indigo-100/50 transition-all text-base" 
                placeholder="Search phone, name, email in entire Vtiger...">
            
            <div id="search-results" class="hidden absolute top-full left-0 w-full mt-2 bg-white rounded-2xl shadow-2xl border border-gray-100 max-h-80 overflow-y-auto p-2 z-50 text-left">
                <p class="text-xs text-gray-400 p-2">Type to search all records...</p>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-2 md:grid-cols-3 gap-6 w-full max-w-4xl">
        
        <a href="modules/dashboard/home.php" class="group bg-white p-6 rounded-[24px] shadow-sm border border-gray-50 hover:shadow-xl hover:shadow-indigo-500/10 hover:-translate-y-1 transition-all duration-300 flex flex-col items-center justify-center gap-4 cursor-pointer">
            <div class="w-16 h-16 rounded-2xl bg-indigo-50 text-indigo-600 flex items-center justify-center text-3xl group-hover:bg-indigo-600 group-hover:text-white transition-colors">
                <i class="ph-bold ph-squares-four"></i>
            </div>
            <div class="text-center">
                <h3 class="text-lg font-bold text-navy-700">Dashboard</h3>
                <p class="text-xs text-gray-400 mt-1">2024 Analytics</p>
            </div>
        </a>

        <a href="modules/leads/list.php" class="group bg-white p-6 rounded-[24px] shadow-sm border border-gray-50 hover:shadow-xl hover:shadow-blue-500/10 hover:-translate-y-1 transition-all duration-300 flex flex-col items-center justify-center gap-4 cursor-pointer">
            <div class="w-16 h-16 rounded-2xl bg-blue-50 text-blue-600 flex items-center justify-center text-3xl group-hover:bg-blue-600 group-hover:text-white transition-colors">
                <i class="ph-bold ph-users-three"></i>
            </div>
            <div class="text-center">
                <h3 class="text-lg font-bold text-navy-700">My Leads</h3>
                <p class="text-xs text-gray-400 mt-1">Manage Pipeline</p>
            </div>
        </a>

        <div class="group bg-gray-50 p-6 rounded-[24px] border border-dashed border-gray-200 flex flex-col items-center justify-center gap-4 opacity-60">
            <div class="w-16 h-16 rounded-2xl bg-white text-gray-400 flex items-center justify-center text-3xl">
                <i class="ph-bold ph-address-book"></i>
            </div>
            <div class="text-center">
                <h3 class="text-lg font-bold text-gray-500">Contacts</h3>
                <p class="text-[10px] text-gray-400 mt-1 bg-gray-200 px-2 py-0.5 rounded-full inline-block">Coming Soon</p>
            </div>
        </div>

    </div>

</div>

<script>
    // Init User Name
    document.addEventListener('DOMContentLoaded', () => {
        const u = localStorage.getItem('vt_username') || 'User';
        document.getElementById('idx-user').innerText = u;
    });

    // GLOBAL SEARCH ENGINE
    let searchTimeout;
    async function performGlobalSearch() {
        const term = document.getElementById('globalSearch').value.trim();
        const resultsBox = document.getElementById('search-results');
        
        if(term.length < 3) { resultsBox.classList.add('hidden'); return; }

        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(async () => {
            resultsBox.innerHTML = '<div class="p-4 text-center"><i class="ph-bold ph-spinner animate-spin text-indigo-600"></i></div>';
            resultsBox.classList.remove('hidden');

            try {
                // GLOBAL API DEFINED IN HEADER
                const q = `SELECT id, label FROM Search WHERE search_label LIKE '%${term}%' LIMIT 10;`; // Basic Vtiger Search Logic
                // Note: Vtiger 'search' operation is often separate, but querying Modules via Search table works in some versions.
                // Alternatively, search Leads directly if global isn't enabled in your API wrapper.
                // Let's use a robust Leads + Contacts search for now to be safe.
                
                const safeQ = `SELECT firstname, lastname, mobile, id FROM Leads WHERE firstname LIKE '%${term}%' OR lastname LIKE '%${term}%' OR mobile LIKE '%${term}%' LIMIT 5;`;
                
                const res = await fetch(`${GLOBAL_API_URL}?operation=query&sessionName=${localStorage.getItem('vt_session')}&query=${encodeURIComponent(safeQ)}`);
                const data = await res.json();

                resultsBox.innerHTML = '';

                if(data.success && data.result.length > 0) {
                    data.result.forEach(item => {
                        const div = document.createElement('div');
                        div.className = "flex items-center justify-between p-3 hover:bg-gray-50 rounded-xl cursor-pointer transition-colors border-b border-gray-50 last:border-0";
                        div.onclick = () => window.location.href = `modules/leads/manage.php?id=${item.id}`; // Smart Redirect
                        
                        div.innerHTML = `
                            <div class="flex items-center gap-3">
                                <div class="w-8 h-8 rounded-full bg-indigo-100 text-indigo-600 flex items-center justify-center">
                                    <i class="ph-bold ph-user"></i>
                                </div>
                                <div>
                                    <p class="text-sm font-bold text-navy-700">${item.firstname} ${item.lastname}</p>
                                    <p class="text-xs text-gray-400">${item.mobile || 'No Phone'}</p>
                                </div>
                            </div>
                            <i class="ph-bold ph-caret-right text-gray-300"></i>
                        `;
                        resultsBox.appendChild(div);
                    });
                } else {
                    resultsBox.innerHTML = `<div class="p-4 text-center text-sm text-gray-400">No records found for "${term}"</div>`;
                }

            } catch (e) {
                console.error(e);
                resultsBox.innerHTML = '<div class="p-2 text-xs text-red-500">Search Error</div>';
            }
        }, 600);
    }

    // Close search on click outside
    document.addEventListener('click', (e) => {
        if (!document.getElementById('globalSearch').contains(e.target)) {
            document.getElementById('search-results').classList.add('hidden');
        }
    });
</script>
<?php // Footer is handled by main layout, closing tags not strictly needed if simple ?>
</body>
</html>