<?php
// PREVENT CACHING
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Pragma: no-cache");

// CONFIGURATION
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
// Auto-detect base URL for assets (images/css)
$base_url = $protocol . $_SERVER['HTTP_HOST'] . strstr($_SERVER['REQUEST_URI'], 'horizon-app', true) . 'horizon-app/';
define('APP_URL', $base_url);

// API URL (The bridge to Vtiger)
// Ensure this matches where you uploaded api_gateway.php
define('CRM_URL', 'https://peopleandplaceseg.com/crm/'); 
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>CRM | People and Places</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/@phosphor-icons/web"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; background-color: #F4F7FE; }
        
        /* Custom Colors */
        .text-navy-700 { color: #1B2559; }
        .bg-navy-700 { background-color: #1B2559; }
        
        .text-horizon-500 { color: #4318FF; }
        .bg-horizon-500 { background-color: #4318FF; }

        /* Active Link Styling */
        .nav-item.active {
            background: linear-gradient(90deg, #4318FF 0%, #6366F1 100%);
            color: #ffffff;
            box-shadow: 0px 10px 20px -10px rgba(67, 24, 255, 0.5);
        }
        .nav-item.active i { color: #ffffff !important; }
        .no-scrollbar::-webkit-scrollbar { display: none; }
    </style>

    <script>
        // Global API Endpoint for JS files
        const GLOBAL_API_URL = "<?php echo CRM_URL; ?>api_gateway.php";
        
        if(!localStorage.getItem('vt_session') && !window.location.href.includes('login.php')) {
            window.location.href = '<?php echo APP_URL; ?>login.php';
        }
    </script>
</head>
<body class="h-screen flex overflow-hidden text-gray-700 bg-[#F4F7FE]">

    <div id="mobile-overlay" onclick="toggleSidebar()" class="fixed inset-0 bg-navy-700/20 backdrop-blur-sm z-40 hidden md:hidden transition-opacity"></div>

    <aside id="sidebar" class="bg-white w-72 h-full fixed md:static top-0 left-0 z-50 flex flex-col border-r border-gray-100 transition-transform duration-300 -translate-x-full md:translate-x-0 shadow-2xl md:shadow-none">
        
        <div class="h-24 flex items-center justify-center px-8 relative border-b border-gray-50">
            <img src="<?php echo APP_URL; ?>assets/img/logo.png" onerror="this.src='https://placehold.co/150x50?text=LOGO'" class="max-h-12 w-auto object-contain">
            <button onclick="toggleSidebar()" class="md:hidden absolute right-4 text-gray-400"><i class="ph-bold ph-x text-xl"></i></button>
        </div>

        <nav class="flex-1 overflow-y-auto py-6 px-4 space-y-2">
            <p class="px-4 text-[10px] font-bold text-gray-400 uppercase tracking-widest mb-2">Platform</p>
            
            <a href="<?php echo APP_URL; ?>modules/dashboard/home.php" class="nav-item flex items-center gap-3 px-4 py-3.5 rounded-2xl text-sm font-bold text-gray-600 hover:bg-gray-50 transition-all group">
                <i class="ph-bold ph-squares-four text-xl text-gray-400 group-hover:text-indigo-500 transition-colors"></i>
                Dashboard
            </a>

            <a href="<?php echo APP_URL; ?>modules/leads/list.php" class="nav-item flex items-center gap-3 px-4 py-3.5 rounded-2xl text-sm font-bold text-gray-600 hover:bg-gray-50 transition-all group">
                <i class="ph-bold ph-users text-xl text-gray-400 group-hover:text-indigo-500 transition-colors"></i>
                My Leads
            </a>
        </nav>

        <div class="p-4 border-t border-gray-100">
            <div class="flex items-center gap-3 p-3 rounded-2xl bg-gradient-to-br from-gray-50 to-white border border-gray-100 shadow-sm mb-3">
                <div id="avatar-circle" class="w-10 h-10 rounded-full bg-gradient-to-tr from-blue-600 to-purple-600 text-white flex items-center justify-center font-bold text-sm shadow-md ring-2 ring-white">U</div>
                <div class="flex-1 min-w-0">
                    <p class="text-sm font-bold text-navy-700 truncate" id="header-username">User</p>
                    <p class="text-[10px] text-gray-400 font-medium">Online</p>
                </div>
                <button onclick="logout()" class="p-2 text-gray-400 hover:text-red-500 transition-colors"><i class="ph-bold ph-sign-out text-lg"></i></button>
            </div>
            
            <div class="text-center">
                <p class="text-[10px] text-gray-300 font-bold tracking-wide">Dev by Helfaya</p>
            </div>
        </div>
    </aside>

    <main class="flex-1 flex flex-col h-full relative overflow-hidden bg-[#F4F7FE]">
        
        <header class="md:hidden h-16 bg-white/80 backdrop-blur-md border-b border-gray-100 flex items-center justify-between px-4 z-30 sticky top-0">
            <button onclick="toggleSidebar()" class="p-2 text-gray-600 hover:bg-gray-100 rounded-xl"><i class="ph-bold ph-list text-2xl"></i></button>
            
            <img src="<?php echo APP_URL; ?>assets/img/logo.png" class="h-8 w-auto object-contain">
            
            <div class="w-10"></div>
        </header>

        <div class="flex-1 overflow-y-auto overflow-x-hidden p-0 md:p-6 scroll-smooth" id="content-scroll">

<script>
    document.addEventListener('DOMContentLoaded', () => {
        // Active Link Logic
        const current = window.location.href;
        document.querySelectorAll('.nav-item').forEach(link => {
            if(current.includes(link.getAttribute('href'))) link.classList.add('active');
        });
        
        // Profile Init
        const u = localStorage.getItem('vt_username') || 'User';
        document.getElementById('header-username').innerText = u;
        const init = u.split(' ').map(n=>n[0]).join('').substring(0,2).toUpperCase();
        if(init) document.getElementById('avatar-circle').innerText = init;
    });

    function toggleSidebar() {
        const sb = document.getElementById('sidebar');
        const overlay = document.getElementById('mobile-overlay');
        sb.classList.toggle('-translate-x-full');
        overlay.classList.toggle('hidden');
    }

    function logout() { localStorage.clear(); window.location.href = '<?php echo APP_URL; ?>login.php'; }
</script>